/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.painter.LinePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class DTreeLineDecoration
implements DTreeDecoration {
    private Painter _hLinePainter;
    private Painter _vLinePainter;
    private Color _lineColor;

    public DTreeLineDecoration() {
        this(new LinePainter(true, false), new LinePainter(false, false), Color.black);
    }

    public DTreeLineDecoration(Painter hLinePainter, Painter vLinePainter, Color lineColor) {
        if (hLinePainter == null || vLinePainter == null) {
            throw new IllegalArgumentException();
        }
        this._hLinePainter = hLinePainter;
        this._vLinePainter = vLinePainter;
        this._lineColor = lineColor;
    }

    @Override
    public ImmInsets getDecorationInsets(DTree tree) {
        return new ImmInsets(0, tree.getIndentWidth(), 0, 0);
    }

    @Override
    public void paintDecoration(PaintContext context, Graphics g, DTreeItem item, int width, int height) {
        if (this.getHasLines(item)) {
            Color savedColor = g.getColor();
            if (this._lineColor != null) {
                g.setColor(this._lineColor);
            }
            DTree tree = item.getTree();
            DTreeItem parent = item.getParent();
            int indentWidth = tree.getIndentWidth();
            DTreeItem nextItem = null;
            if (parent != null) {
                int itemcount = parent.getItemCount();
                int index = item.getIndex();
                if (index < itemcount - 1) {
                    nextItem = parent.getItem(index + 1);
                }
            }
            int itemY = item.getY();
            g.translate(0, -itemY);
            int halfIndentWidth = indentWidth / 2;
            this._hLinePainter.paint(context, g, width - halfIndentWidth, itemY, halfIndentWidth, height);
            if (nextItem != null) {
                int y1 = itemY + height / 2;
                int y2 = nextItem.getY();
                Rectangle clip = g.getClipBounds();
                if (y1 < clip.y) {
                    y1 = clip.y;
                }
                this._vLinePainter.paint(context, g, width - indentWidth, y1, indentWidth, y2 - y1);
            }
            if (parent != tree.getRoot() || item.getIndex() != 0) {
                this._vLinePainter.paint(context, g, width - indentWidth, itemY, indentWidth, height / 2);
            }
            g.translate(0, itemY);
            g.setColor(savedColor);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent evt, DTreeItem item) {
    }

    protected boolean getHasLines(DTreeItem item) {
        return true;
    }
}

