/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.elaf.EWTDateEditorUI;
import oracle.bali.ewt.elaf.basic.DateEditorPainter;
import oracle.bali.ewt.elaf.basic.DateEditorUtils;
import oracle.bali.ewt.elaf.windows.WindowsEWTSpinnerUI;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.ImmInsets;

public class WindowsEWTDateEditorUI
extends WindowsEWTSpinnerUI
implements EWTDateEditorUI {
    private Painter _textPainter;
    private Painter _selectionPainter;
    private static final int _GAP = 1;
    private static WindowsEWTDateEditorUI _sInstance;

    private WindowsEWTDateEditorUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTDateEditorUI();
        }
        return _sInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent component) {
        DateEditor editor = (DateEditor)component;
        Component c = WindowsEWTDateEditorUI.getSpinButton(editor);
        Dimension spinPref = c.getPreferredSize();
        Dimension painterSize = DateEditorUtils.getPreferredSize(editor, this);
        ImmInsets i = editor.getBorderInsets();
        ImmInsets spinInsets = this.getSpinButtonInsets(component);
        int verticalInsets = i.top + i.bottom;
        return new Dimension(spinPref.width + painterSize.width + 1 + i.left + i.right + spinInsets.left + spinInsets.right, Math.max(painterSize.height + verticalInsets, spinPref.height + verticalInsets + spinInsets.top + spinInsets.bottom));
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        DateEditor editor = (DateEditor)component;
        Painter painter = this.getTextPainter(editor);
        Dimension painterSize = painter.getMinimumSize(editor.getPaintContext());
        Component c = WindowsEWTDateEditorUI.getSpinButton(editor);
        Dimension spinSize = c.getMinimumSize();
        if (painterSize.height < spinSize.height) {
            painterSize.height = spinSize.height;
        }
        painterSize.width += spinSize.width;
        return painterSize;
    }

    @Override
    public Dimension getMaximumSize(JComponent component) {
        Dimension d = this.getPreferredSize(component);
        return d;
    }

    @Override
    public Painter getTextPainter(JComponent component) {
        if (this._textPainter == null) {
            this._textPainter = new DisablingPainter(new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2), true);
        }
        return this._textPainter;
    }

    @Override
    public Painter getSelectionTextPainter(JComponent component) {
        if (this._selectionPainter == null) {
            this._selectionPainter = new DateEditorPainter(new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2));
        }
        return this._selectionPainter;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        DateEditor de = (DateEditor)c;
        Color oldColor = g.getColor();
        Insets insets = de.getInsets();
        g.setColor(de.getBackground());
        g.fillRect(0, 0, de.getSize().width, de.getSize().height);
        g.translate(insets.left, insets.top);
        g.setColor(oldColor);
        de.paintInterior(g);
        g.translate(-insets.left, -insets.top);
    }
}

