/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import java.util.Random;
import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;

public class FixedSizeGeometryManager
extends AbstractWrappingGeometryManager {
    public static final int RESIZE_REMAINING = 0;
    public static final int RESIZE_NEXT = 1;
    private int _method;
    private float[] _cachedMinProportions;
    private float[] _cachedMaxProportions;

    public FixedSizeGeometryManager(GeometryManager geometryManager) {
        this(geometryManager, 0);
    }

    public FixedSizeGeometryManager(GeometryManager geometryManager, int method) {
        super(geometryManager);
        this._method = method;
    }

    @Override
    protected GeometryListener createGeometryListener() {
        return new ListenerAdapter();
    }

    @Override
    public void setTotalSize(int size) {
        int oldSize = this.getTotalSize();
        this._cachedMinProportions = this._cacheMinProportions(0);
        this._cachedMaxProportions = this._cacheMaxProportions(0);
        int result = this._resize(-1, size);
        this._cachedMinProportions = null;
        this._cachedMaxProportions = null;
        this.fireGeometryEvent(2002, -1, this.getTotalSize());
    }

    @Override
    public void setItemSize(int modelIndex, int size) {
        int max;
        int min = this.getMinimumItemSize(modelIndex);
        if (size < min) {
            size = min;
        }
        if (size > (max = this.getMaximumItemSize(modelIndex))) {
            size = max;
        }
        int visIndex = this.getItemVisibleIndex(modelIndex);
        if (this._method == 1 && visIndex + 1 < this.getVisibleItemCount()) {
            int oldsize = this.getItemSize(modelIndex);
            int nextindex = this.visibleIndexToIndex(visIndex + 1);
            int nextsize = this.getItemSize(nextindex);
            int totalsize = oldsize + nextsize;
            super.setItemSize(nextindex, totalsize - size);
            nextsize = this.getItemSize(nextindex);
            super.setItemSize(modelIndex, totalsize - nextsize);
        } else {
            if (this._cachedMinProportions == null) {
                this._cachedMinProportions = this._cacheMinProportions(visIndex + 1);
            }
            if (this._cachedMaxProportions == null) {
                this._cachedMaxProportions = this._cacheMaxProportions(visIndex + 1);
            }
            int desiredRemaining = this.getTotalSize() - this.getItemPosition(modelIndex) - size - this.getSeparatorSize();
            super.setItemSize(modelIndex, size -= this._resize(visIndex, desiredRemaining));
            if (!this.isResizing()) {
                this._cachedMinProportions = null;
                this._cachedMaxProportions = null;
            }
        }
        this.fireGeometryEvent(2005, modelIndex, this.getItemSize(modelIndex));
    }

    private float[] _cacheMinProportions(int startIndex) {
        int dsIndex;
        int i;
        int count = this.getVisibleItemCount();
        float[] result = new float[count];
        int total = 0;
        for (i = startIndex; i < count; ++i) {
            dsIndex = this.visibleIndexToIndex(i);
            if (!this.isItemResizable(dsIndex)) continue;
            total += this.getItemSize(dsIndex) - this.getMinimumItemSize(dsIndex);
        }
        if (total != 0) {
            for (i = startIndex; i < count; ++i) {
                dsIndex = this.visibleIndexToIndex(i);
                if (!this.isItemResizable(dsIndex)) continue;
                result[i] = (float)(this.getItemSize(dsIndex) - this.getMinimumItemSize(dsIndex)) / (float)total;
            }
        }
        return result;
    }

    private float[] _cacheMaxProportions(int startIndex) {
        int dsIndex;
        int i;
        int count = this.getVisibleItemCount();
        float[] result = new float[count];
        long total = 0L;
        for (i = startIndex; i < count; ++i) {
            dsIndex = this.visibleIndexToIndex(i);
            if (!this.isItemResizable(dsIndex)) continue;
            total += (long)(this.getMaximumItemSize(dsIndex) - this.getItemSize(dsIndex));
        }
        if (total != 0L) {
            for (i = startIndex; i < count; ++i) {
                dsIndex = this.visibleIndexToIndex(i);
                if (!this.isItemResizable(dsIndex)) continue;
                result[i] = (float)(this.getMaximumItemSize(dsIndex) - this.getItemSize(dsIndex)) / (float)total;
            }
        }
        return result;
    }

    private int _resize(int visibleIndex, int desiredRemaining) {
        int result;
        int dsIndex;
        int i;
        int actualRemaining = 0;
        int count = this.getVisibleItemCount();
        for (i = visibleIndex + 1; i < count; ++i) {
            dsIndex = this.visibleIndexToIndex(i);
            int itemSize = this.getItemSize(dsIndex);
            actualRemaining += itemSize;
        }
        if ((actualRemaining += this.getSeparatorSize() * (count - (visibleIndex + 1))) > desiredRemaining) {
            int finalRemaining;
            int needed;
            result = needed = actualRemaining - desiredRemaining;
            do {
                needed = result;
                finalRemaining = 0;
                for (i = visibleIndex + 1; i < count; ++i) {
                    dsIndex = this.visibleIndexToIndex(i);
                    if (this.isItemResizable(dsIndex)) {
                        int size = this.getItemSize(dsIndex);
                        float neededhere = (float)needed * this._cachedMinProportions[i];
                        int curSize = size - (int)neededhere;
                        super.setItemSize(dsIndex, curSize);
                    }
                    finalRemaining += this.getItemSize(dsIndex) + this.getSeparatorSize();
                }
            } while ((result = finalRemaining - desiredRemaining) != needed);
            result = this.distributePixels(result, visibleIndex + 1, -1);
        } else if (actualRemaining < desiredRemaining) {
            int finalRemaining;
            int needed = desiredRemaining - actualRemaining;
            result = -needed;
            do {
                finalRemaining = 0;
                needed = -result;
                for (i = visibleIndex + 1; i < count; ++i) {
                    dsIndex = this.visibleIndexToIndex(i);
                    if (this.isItemResizable(dsIndex)) {
                        int size = this.getItemSize(dsIndex);
                        int curSize = size + (int)((float)needed * this._cachedMaxProportions[i]);
                        super.setItemSize(dsIndex, curSize);
                    }
                    finalRemaining += this.getItemSize(dsIndex) + this.getSeparatorSize();
                }
            } while (-(result = finalRemaining - desiredRemaining) != needed);
            result = this.distributePixels(result, visibleIndex + 1, 1);
        } else {
            result = 0;
        }
        return result;
    }

    private int distributePixels(int pixels, int startIndex, int factor) {
        if (pixels == 0) {
            return 0;
        }
        int count = this.getVisibleItemCount();
        int limit = count - startIndex;
        Random r = new Random();
        boolean keeptrying = true;
        while (keeptrying && pixels != 0) {
            int oldSize;
            int dsIndex;
            int i;
            keeptrying = false;
            int rand = r.nextInt(limit);
            for (i = startIndex + rand; i < count && pixels != 0; ++i) {
                dsIndex = this.visibleIndexToIndex(i);
                if (!this.isItemResizable(dsIndex)) continue;
                oldSize = this.getItemSize(dsIndex);
                super.setItemSize(dsIndex, oldSize + 1 * factor);
                if (this.getItemSize(dsIndex) == oldSize) continue;
                pixels += 1 * factor;
                keeptrying = true;
            }
            for (i = startIndex; i < startIndex + rand && pixels != 0; ++i) {
                dsIndex = this.visibleIndexToIndex(i);
                if (!this.isItemResizable(dsIndex)) continue;
                oldSize = this.getItemSize(dsIndex);
                super.setItemSize(dsIndex, oldSize + 1 * factor);
                if (this.getItemSize(dsIndex) == oldSize) continue;
                pixels += 1 * factor;
                keeptrying = true;
            }
        }
        return pixels;
    }

    private class ListenerAdapter
    implements GeometryListener {
        private ListenerAdapter() {
        }

        @Override
        public void geometryChanged(GeometryEvent e) {
            int id = e.getID();
            if (id == 2002 || id == 2005 || id == 2006 || id == 2007) {
                return;
            }
            FixedSizeGeometryManager.this.fireGeometryEvent(id, e.getItem(), e.getSize());
        }
    }
}

