/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import oracle.bali.ewt.model.AbstractTwoDModel;

public class ArrayTwoDModel
extends AbstractTwoDModel {
    private int _columns;
    private int _rows;
    private Object[][] _data;
    private static int _ROWS_ALLOCATED_AHEAD = 20;

    public ArrayTwoDModel(int columns, int rows) {
        this._columns = columns;
        this._rows = rows;
    }

    public ArrayTwoDModel(Object[][] contents) {
        int numColumns;
        int numRows;
        if (contents != null && (numRows = contents.length) != 0 && (numColumns = contents[0].length) != 0) {
            Object[][] data = new Object[numRows][numColumns];
            System.arraycopy(contents, 0, data, 0, numRows);
            for (int i = 0; i < numRows; ++i) {
                Object[] currRow = new Object[numColumns];
                System.arraycopy(contents[i], 0, currRow, 0, numColumns);
                data[i] = currRow;
            }
            this._data = data;
            this._rows = numRows;
            this._columns = numColumns;
        }
    }

    public void addRows(int startIndex, int numberOfRows) {
        this._addRowsToArray(startIndex, numberOfRows);
        this._rows += numberOfRows;
        this.fireModelEvent(2004, startIndex, numberOfRows);
    }

    public void removeRows(int startIndex, int numberOfRows) {
        this._removeRowsFromArray(startIndex, numberOfRows);
        this._rows -= numberOfRows;
        this.fireModelEvent(2005, startIndex, numberOfRows);
    }

    public void addColumns(int startIndex, int numberOfColumns) {
        this._addColumnsToArray(startIndex, numberOfColumns);
        this._columns += numberOfColumns;
        this.fireModelEvent(2001, startIndex, numberOfColumns);
    }

    public void removeColumns(int startIndex, int numberOfColumns) {
        this._removeColumnsFromArray(startIndex, numberOfColumns);
        this._columns -= numberOfColumns;
        this.fireModelEvent(2002, startIndex, numberOfColumns);
    }

    @Override
    public int getColumnCount() {
        return this._columns;
    }

    @Override
    public int getRowCount() {
        return this._rows;
    }

    @Override
    public Object getData(int columnIndex, int rowIndex) {
        if (rowIndex >= this._rows || columnIndex >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            return null;
        }
        Object[] row = this._data[rowIndex];
        if (row == null) {
            return null;
        }
        return row[columnIndex];
    }

    @Override
    public void setData(int columnIndex, int rowIndex, Object data) {
        Object[] row;
        if (rowIndex >= this._rows || columnIndex >= this._columns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._data == null) {
            this._data = new Object[this._rows][];
        }
        if ((row = this._data[rowIndex]) == null) {
            row = new Object[this._columns];
            this._data[rowIndex] = row;
        }
        row[columnIndex] = data;
        this.fireModelEvent(2007, columnIndex, 1, rowIndex, 1);
    }

    private void _addRowsToArray(int start, int number) {
        Object[][] dst;
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._rows;
        if (src.length >= length + number) {
            dst = src;
        } else {
            dst = new Object[length + number + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(src, 0, dst, 0, start);
            this._data = dst;
        }
        System.arraycopy(src, start, dst, start + number, length - start);
        if (dst == src) {
            int rowIndex = start;
            for (int i = 0; i < number; ++i) {
                src[rowIndex++] = null;
            }
        }
    }

    private void _removeRowsFromArray(int start, int number) {
        Object[][] dst;
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._rows;
        if (length - number + _ROWS_ALLOCATED_AHEAD < src.length / 2) {
            dst = new Object[length - number + _ROWS_ALLOCATED_AHEAD][];
            System.arraycopy(src, 0, dst, 0, start);
            this._data = dst;
        } else {
            dst = src;
        }
        System.arraycopy(src, start + number, dst, start, length - start - number);
        if (dst == src) {
            int rowIndex = length;
            for (int i = 0; i < number; ++i) {
                src[--rowIndex] = null;
            }
        }
    }

    private void _addColumnsToArray(int start, int number) {
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._columns;
        int newLength = length + number;
        int secondStart = start + number;
        int secondLength = length - start;
        for (int i = 0; i < this._rows; ++i) {
            Object[] srcRow = src[i];
            if (srcRow == null) continue;
            Object[] dstRow = new Object[newLength];
            System.arraycopy(srcRow, 0, dstRow, 0, start);
            System.arraycopy(srcRow, start, dstRow, secondStart, secondLength);
            src[i] = dstRow;
        }
    }

    private void _removeColumnsFromArray(int start, int number) {
        Object[][] src = this._data;
        if (src == null) {
            return;
        }
        int length = this._columns;
        int newLength = length - number;
        int secondStart = start + number;
        int secondLength = length - start - number;
        for (int i = 0; i < this._rows; ++i) {
            Object[] srcRow = src[i];
            if (srcRow == null) continue;
            Object[] dstRow = new Object[newLength];
            System.arraycopy(srcRow, 0, dstRow, 0, start);
            System.arraycopy(srcRow, secondStart, dstRow, start, secondLength);
            src[i] = dstRow;
        }
    }
}

