/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicButtonListener;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;

class OracleButtonListener
extends BasicButtonListener {
    private static KeyStroke _spacePressedKeyStroke = KeyStroke.getKeyStroke(32, 0, false);
    private static KeyStroke _spaceReleasedKeyStroke = KeyStroke.getKeyStroke(32, 0, true);
    private static KeyStroke _enterPressedKeyStroke = KeyStroke.getKeyStroke(10, 0, false);
    private static KeyStroke _enterReleasedKeyStroke = KeyStroke.getKeyStroke(10, 0, true);

    public OracleButtonListener(AbstractButton b) {
        super(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        Object newValue = e.getNewValue();
        AbstractButton b = (AbstractButton)e.getSource();
        if ("opaque".equals(propertyName)) {
            if (Boolean.TRUE.equals(newValue)) {
                b.setOpaque(false);
            }
        } else if ("ancestor".equals(propertyName) && newValue == null) {
            b.getModel().setRollover(false);
        }
    }

    @Override
    public void installKeyboardActions(JComponent c) {
        super.installKeyboardActions(c);
        if (c instanceof JButton) {
            c.registerKeyboardAction(c.getActionForKeyStroke(_spacePressedKeyStroke), _enterPressedKeyStroke, 0);
            c.registerKeyboardAction(c.getActionForKeyStroke(_spaceReleasedKeyStroke), _enterReleasedKeyStroke, 0);
        }
    }

    @Override
    public void uninstallKeyboardActions(JComponent c) {
        super.uninstallKeyboardActions(c);
        if (c instanceof JButton) {
            c.unregisterKeyboardAction(_enterPressedKeyStroke);
            c.unregisterKeyboardAction(_enterReleasedKeyStroke);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        AbstractButton ab = (AbstractButton)e.getSource();
        ab.repaint();
        AbstractButtonPaintContext.__setFocusedButton(ab);
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        AbstractButtonPaintContext.__setFocusedButton(null);
    }

    @Override
    protected void checkOpacity(AbstractButton b) {
    }
}

