/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class JDKPivotDragDropAdapter
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    PivotHeader _pivotHeader;
    private DragGestureRecognizer _headerRecognizer;
    private DragGestureRecognizer _gridRecognizer;
    private DropTarget _gridDropTarget;
    private DropTarget _headerDropTarget;

    public JDKPivotDragDropAdapter(PivotHeader pivotHeader) {
        this._pivotHeader = pivotHeader;
        Header header = JDKPivotDragDropAdapter._isHorizontal(this._pivotHeader) ? this._pivotHeader.getRowHeader() : this._pivotHeader.getColumnHeader();
        this._headerRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(header, 2, this);
        this._headerDropTarget = new DropTarget(header, this);
        Grid grid = this._pivotHeader.getGrid();
        this._gridRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(grid, 2, this);
        this._gridDropTarget = new DropTarget(this._pivotHeader.getGrid(), this);
    }

    public void dispose() {
        this._headerDropTarget.setComponent(null);
        this._headerDropTarget.removeDropTargetListener(this);
        this._headerDropTarget = null;
        this._gridDropTarget.setComponent(null);
        this._gridDropTarget.removeDropTargetListener(this);
        this._gridDropTarget = null;
        this._headerRecognizer.setComponent(null);
        this._headerRecognizer.removeDragGestureListener(this);
        this._headerRecognizer = null;
        this._gridRecognizer.setComponent(null);
        this._gridRecognizer.removeDragGestureListener(this);
        this._gridRecognizer = null;
        this._pivotHeader = null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (!this._acceptDrag(e)) {
            e.rejectDrag();
            return;
        }
        boolean inHeader = e.getDropTargetContext().getComponent() instanceof Header;
        Point p = e.getLocation();
        boolean isSwap = this._pivotHeader.isSwap(p, inHeader);
        int index = this._pivotHeader.getDropIndex(p, inHeader, isSwap);
        this._setDropLocation(index, isSwap);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this._setDropLocation(-1, false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        this._setDropLocation(-1, false);
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException ioException) {
            data = null;
        }
        catch (UnsupportedFlavorException ufException) {
            data = null;
        }
        boolean success = false;
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)data;
            Object source = pivotTransfer.getSource();
            int sourceIndex = pivotTransfer.getIndex();
            PivotHeader destination = this._pivotHeader;
            Point p = e.getLocation();
            boolean inHeader = e.getDropTargetContext().getComponent() instanceof Header;
            boolean isSwap = this._pivotHeader.isSwap(p, inHeader);
            int destinationIndex = this._pivotHeader.getDropIndex(e.getLocation(), inHeader, isSwap);
            boolean fireEvent = true;
            if (source == destination) {
                if (!isSwap && sourceIndex < destinationIndex) {
                    --destinationIndex;
                }
                if (sourceIndex == destinationIndex) {
                    fireEvent = false;
                }
            }
            if (fireEvent) {
                if (!isSwap) {
                    this._pivotHeader.firePivotEvent(source, sourceIndex, destination, destinationIndex);
                } else {
                    this._pivotHeader.fireSwapEvent(source, sourceIndex, destination, destinationIndex);
                }
            }
            success = true;
        }
        e.dropComplete(success);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        boolean inHeader;
        if (!this._pivotHeader.isDragEnabled() || this._pivotHeader.isDrilling() || this._pivotHeader.getResizeItem() != -1) {
            return;
        }
        Point origin = e.getDragOrigin();
        int index = this._pivotHeader.getDragIndex(origin, inHeader = e.getComponent() != this._pivotHeader.getGrid());
        if (index != -1) {
            Image dragImage = this._pivotHeader.getDragImage(index);
            this._pivotHeader.setDragItem(index);
            this._adjustOrigin(origin, inHeader, index);
            e.startDrag(null, dragImage, origin, PivotTransfer.createTransferable(this._pivotHeader, index), this);
            Object[] events = e.toArray();
            Object toConsume = events[events.length - 1];
            if (toConsume instanceof InputEvent) {
                ((InputEvent)toConsume).consume();
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        this._pivotHeader.setDragItem(-1);
    }

    private void _adjustOrigin(Point p, boolean inHeader, int dragIndex) {
        boolean horizontal;
        boolean bl = horizontal = this._pivotHeader.getOrientation() == 0;
        if (inHeader) {
            Header header = this._pivotHeader.getHeader();
            int index = header.getItemAt(p.x, p.y);
            if (index != -1) {
                if (horizontal) {
                    p.x = 5;
                    p.y -= header.getItemPosition(index);
                    p.y = -p.y;
                } else {
                    p.x -= header.getItemPosition(index);
                    p.x = -p.x;
                    p.y = 5;
                }
            }
        } else {
            Grid grid = this._pivotHeader.getGrid();
            int originColumn = grid.getColumnAt(p.x);
            int originRow = grid.getRowAt(p.y);
            if (originColumn != -1 && originRow != -1) {
                if (horizontal) {
                    p.x = 5;
                    p.y -= grid.getRowPosition(originRow);
                    p.y = -p.y;
                } else {
                    p.x -= grid.getColumnPosition(originColumn);
                    p.x = -p.x;
                    p.y = 5;
                }
            }
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this._pivotHeader.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private void _setDropLocation(int index, boolean isSwap) {
        this._pivotHeader.setDropLocation(index, isSwap);
    }

    private static boolean _isHorizontal(PivotHeader header) {
        return header.getOrientation() == 0;
    }
}

