/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class TypeOp
extends Expr {
    OXMLSequenceType userSpecifiedType;
    private byte operator;
    public static final byte INSTANCE_OF = 1;
    public static final byte CAST = 2;
    public static final byte CASTABLE = 3;
    public static final byte TREAT = 4;
    public static final byte TYPESWITCH = 5;
    private static String[] opStr = new String[]{"instanceof", "cast", "castable", "treat", "typeswitch"};

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)TypeOp.getDoc().createElement("SequenceTypeOp");
        xMLElement.setAttribute("op", opStr[this.operator - 1]);
        if (this.userSpecifiedType != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.userSpecifiedType.toString(stringBuffer);
            xMLElement.setAttribute("userSpecifiedType", stringBuffer.toString());
        }
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        throw new XQException("TypeOp: getStrRep() not supported");
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        throw new XQException("TypeOp: toSql() not supported");
    }

    @Override
    public int getDatatype() {
        throw new XQException("TypeOp: getDatatype() not supported");
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        throw new XQException("TypeOp: fromXML() not supported");
    }

    public TypeOp(byte by, Expr expr, OXMLSequenceType oXMLSequenceType) {
        super(expr);
        this.operator = by;
        this.userSpecifiedType = oXMLSequenceType;
    }

    public TypeOp(byte by, Expr[] exprArray) {
        super(exprArray);
        this.operator = by;
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLSequence oXMLSequence = null;
        OXMLSequence oXMLSequence2 = this.kids[0].Evaluate(queryState);
        switch (this.operator) {
            case 1: {
                boolean bl = oXMLSequence2.isOfType(this.userSpecifiedType);
                OXMLItem oXMLItem = queryState.createItem();
                oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
                oXMLSequence = queryState.createSequence();
                oXMLSequence.appendItem(oXMLItem);
                oXMLSequence.setKnownType(OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 2: {
                oXMLSequence = queryState.createSequence();
                this.cast(queryState, oXMLSequence2, oXMLSequence);
                break;
            }
            case 3: {
                boolean bl = true;
                try {
                    this.cast(queryState, oXMLSequence2, null);
                }
                catch (XQException xQException) {
                    bl = false;
                }
                OXMLItem oXMLItem = queryState.createItem();
                oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
                oXMLSequence = queryState.createSequence();
                oXMLSequence.appendItem(oXMLItem);
                oXMLSequence.setKnownType(OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 4: {
                if (this.kids[0].unknownStaticType() && !oXMLSequence2.isOfType(this.userSpecifiedType)) {
                    throw new XQException(queryState.getMesg().getMessage0("XPDY0050"));
                }
                oXMLSequence = oXMLSequence2;
                break;
            }
            case 5: {
                oXMLSequence = this.typeswitch(queryState, oXMLSequence2);
            }
        }
        return oXMLSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cast(QueryState queryState, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        OXMLItem oXMLItem;
        boolean bl = this.kids[0].needAtomization();
        OXMLSequence oXMLSequence3 = oXMLSequence;
        if (bl) {
            oXMLSequence3 = oXMLSequence.atomize();
        }
        if ((oXMLItem = XQueryUtils.getEmptyOrSingleItem(oXMLSequence3)) == null) {
            if (this.userSpecifiedType.getOccurence() != 2) throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            if (oXMLSequence2 != null) {
                oXMLSequence2.setKnownType(OXMLSequenceType.EMPTY_SEQUENCE);
            }
        } else {
            oXMLItem = XQueryUtils.convert(oXMLItem, this.userSpecifiedType, queryState);
            if (oXMLSequence2 != null) {
                oXMLSequence2.appendItem(oXMLItem);
                oXMLSequence2.setKnownType(this.userSpecifiedType);
            }
        }
        if (!bl) return;
        queryState.returnSequence(oXMLSequence3);
    }

    private OXMLSequence typeswitch(QueryState queryState, OXMLSequence oXMLSequence) {
        VarExpr varExpr;
        int n;
        for (n = 1; n < this.kids.length - 2; n += 2) {
            varExpr = (VarExpr)this.kids[n];
            if (!oXMLSequence.isOfType(varExpr.getDefinedType())) continue;
            varExpr.setValue(false, oXMLSequence, queryState);
            return this.kids[n + 1].Evaluate(queryState);
        }
        if (n < this.kids.length - 1) {
            varExpr = (VarExpr)this.kids[n];
            varExpr.setValue(false, oXMLSequence, queryState);
        }
        return this.kids[this.kids.length - 1].Evaluate(queryState);
    }

    int getOperator() {
        return this.operator;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitSequenceTypeExpr(this);
    }
}

