/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.Statement;
import oracle.dbtools.jdbc.util.DateTimestampsUtil;
import oracle.dbtools.jdbc.util.ExceptionUtil;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.OracleTypes;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    Logger LOGGER = Logger.getLogger(PreparedStatement.class.getName());
    protected JsonFactory f = new JsonFactory();
    protected Writer writer = new StringWriter();
    protected JsonGenerator g = null;
    protected boolean closed = false;
    private java.sql.ResultSet currResultSet = null;
    protected boolean isCloseOnCompletion = false;
    protected int batchIndex = 0;
    protected boolean outParams = false;
    protected Map<Object, LinkedList<Object>> data = new HashMap<Object, LinkedList<Object>>();
    protected Map<Object, String> types = new HashMap<Object, String>();
    protected Map<Object, Integer> outTypes = new HashMap<Object, Integer>();

    protected PreparedStatement() {
    }

    protected PreparedStatement(Connection conn, String sql) {
        this.conn = conn;
        this.sql = sql;
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        CloseableHttpResponse response = this.executeInternal(this.sql);
        ++this.rsCount;
        this.updateCount = -1;
        this.currResultSet = new ResultSet(response, this, this.conn, this.sql);
        return this.currResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int result = 0;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            TreeNode node = this.createJsonNode(response);
            this.handleErrors(node);
            result = this.getResult(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                    ExceptionUtil.throwSQLException(17001);
                }
            }
        }
        this.updateCount = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            response = this.executeInternal(this.sql);
            TreeNode node = this.createJsonNode(response);
            if (node.get("items").get(0).get("resultSet") != null) {
                result = true;
            }
            this.handleErrors(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                    ExceptionUtil.throwSQLException(17001);
                }
            }
        }
        this.updateCount = 0;
        return result;
    }

    @Override
    protected CloseableHttpResponse executeInternal(String sql) throws SQLException {
        this.ensureOpen();
        CloseableHttpResponse response = null;
        Session session = this.conn.getSession();
        StringBuilder uri = new StringBuilder();
        uri.append(this.conn.getUri());
        uri.append("_/sql");
        URI root = URI.create(uri.toString());
        try {
            HttpPost post = session.createPost(root);
            post.addHeader("Content-Type", "application/json");
            if (this.types.isEmpty() && this.outTypes.isEmpty()) {
                this.LOGGER.fine("No bind variables set");
                AbstractMap.SimpleEntry<JsonGenerator, Writer> simpleEntry = this.generatePost(sql, 0);
                JsonGenerator g = simpleEntry.getKey();
                Writer writer = simpleEntry.getValue();
                g.close();
                StringEntity strEntity = new StringEntity(writer.toString());
                post.setEntity((HttpEntity)strEntity);
            } else {
                this.LOGGER.fine("Bind variables are set");
                AbstractMap.SimpleEntry<JsonGenerator, Writer> simpleEntry = this.generatePost(sql, 0);
                JsonGenerator g = null;
                if (!this.types.isEmpty()) {
                    g = this.batchIndex == 0 ? this.processSets(simpleEntry.getKey()) : this.processBatchSets(simpleEntry.getKey());
                }
                if (!this.outTypes.isEmpty()) {
                    g = g == null ? this.processOUTs(simpleEntry.getKey()) : this.processOUTs(g);
                }
                Writer writer = simpleEntry.getValue();
                g.close();
                StringEntity strEntity = new StringEntity(writer.toString());
                post.setEntity((HttpEntity)strEntity);
            }
            response = session.executeRequest((HttpUriRequest)post);
        }
        catch (IOException | IllegalStateException | SessionException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
            ExceptionUtil.throwSQLException(17001, (Exception)e);
        }
        return response;
    }

    @Override
    protected AbstractMap.SimpleEntry<JsonGenerator, Writer> generatePost(String sql, int offset) throws SQLException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = null;
        String stmtTxt = "statementText";
        String binds = "binds";
        try {
            long fetchSize = this.getFetchSize();
            g = f.createGenerator((Writer)writer);
            g.writeStartObject();
            g.writeStringField(stmtTxt, sql);
            g.writeStringField("emulate", "jdbc");
            g.writeNumberField("offset", offset);
            if (fetchSize > 0L) {
                g.writeNumberField("limit", fetchSize);
            } else {
                g.writeNumberField("limit", 25);
            }
            if (this.types.isEmpty() && this.outTypes.isEmpty()) {
                g.writeEndObject();
            } else {
                g.writeFieldName(binds);
                g.writeStartArray();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
            ExceptionUtil.throwSQLException(17002);
        }
        return new AbstractMap.SimpleEntry<JsonGenerator, Writer>(g, writer);
    }

    private JsonGenerator processOUTs(JsonGenerator g) throws SQLException {
        try {
            for (Object i : this.outTypes.keySet()) {
                if (this.types.containsKey(i)) continue;
                g.writeStartObject();
                if (i instanceof Integer) {
                    g.writeNumberField("index", ((Integer)i).intValue());
                } else if (i instanceof String) {
                    g.writeStringField("name", (String)i);
                }
                switch (this.outTypes.get(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        g.writeStringField("data_type", "NUMBER");
                        break;
                    }
                    case 6: {
                        g.writeStringField("data_type", "FLOAT");
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 70: {
                        g.writeStringField("data_type", "VARCHAR");
                        break;
                    }
                    case 91: {
                        g.writeStringField("data_type", "DATE");
                        break;
                    }
                    case 92: {
                        g.writeStringField("data_type", "TIME");
                        break;
                    }
                    case 93: {
                        g.writeStringField("data_type", "TIMESTAMP");
                        break;
                    }
                    case 2004: {
                        g.writeStringField("data_type", "BLOB");
                        break;
                    }
                    case 2005: {
                        g.writeStringField("data_type", "CLOB");
                        break;
                    }
                    case 16: {
                        g.writeStringField("data_type", "BOOLEAN");
                        break;
                    }
                    case -7: {
                        g.writeStringField("data_type", "BIT");
                    }
                }
                g.writeStringField("mode", "out");
                g.writeEndObject();
            }
        }
        catch (IOException e) {
            this.LOGGER.severe("Failure while generating POST\n" + e.getMessage());
            ExceptionUtil.throwSQLException(17001);
        }
        return g;
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.currResultSet = null;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.updateCount;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.ensureOpen();
        return this.currResultSet;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setFetchDirection(int direction)", this.getClass().getSimpleName()));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isCloseOnCompletion && this.rsCount == 0L) {
            this.close();
        }
        return this.closed;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        if (!this.closed) {
            this.isCloseOnCompletion = true;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    protected JsonGenerator processSets(JsonGenerator g) throws SQLException {
        String value = "value";
        try {
            for (Object i : this.types.keySet()) {
                g.writeStartObject();
                if (i instanceof Integer) {
                    g.writeNumberField("index", ((Integer)i).intValue());
                } else if (i instanceof String) {
                    g.writeStringField("name", (String)i);
                }
                String data_type = this.types.get(i);
                if (!data_type.equals("DOUBLE") && !data_type.equals("BIGDECIMAL")) {
                    g.writeStringField("data_type", this.types.get(i));
                }
                if (this.outTypes.containsKey(i)) {
                    g.writeStringField("mode", "inout");
                }
                switch (this.types.get(i)) {
                    case "BOOLEAN": 
                    case "BIT": {
                        g.writeBooleanField(value, ((Boolean)this.data.get(i).getLast()).booleanValue());
                        break;
                    }
                    case "byte": {
                        break;
                    }
                    case "SHORT": {
                        g.writeNumberField(value, (int)((Short)this.data.get(i).getLast()).shortValue());
                        break;
                    }
                    case "INTEGER": {
                        g.writeNumberField(value, ((Integer)this.data.get(i).getLast()).intValue());
                        break;
                    }
                    case "NUMBER": {
                        if (this.data.get(i).getLast() instanceof Integer) {
                            g.writeNumberField(value, ((Integer)this.data.get(i).getLast()).intValue());
                            break;
                        }
                        if (this.data.get(i).getLast() instanceof Short) {
                            g.writeNumberField(value, (int)((Short)this.data.get(i).getLast()).shortValue());
                            break;
                        }
                        if (this.data.get(i).getLast() instanceof Long) {
                            g.writeNumberField(value, ((Long)this.data.get(i).getLast()).longValue());
                            break;
                        }
                        if (this.data.get(i).getLast() instanceof Double) {
                            g.writeNumberField(value, ((Double)this.data.get(i).getLast()).doubleValue());
                            break;
                        }
                        g.writeNumberField(value, (BigDecimal)this.data.get(i).getLast());
                        break;
                    }
                    case "VARCHAR": 
                    case "DATALINK": {
                        g.writeStringField(value, (String)this.data.get(i).getLast());
                        break;
                    }
                    case "VARCHAR2": {
                        g.writeStringField(value, (String)this.data.get(i).getLast());
                        break;
                    }
                    case "FLOAT": {
                        g.writeNumberField(value, ((Float)this.data.get(i).getLast()).floatValue());
                        break;
                    }
                    case "DOUBLE": {
                        g.writeStringField("data_type", "NUMBER");
                        g.writeNumberField(value, ((Double)this.data.get(i).getLast()).doubleValue());
                        break;
                    }
                    case "BIGDECIMAL": {
                        g.writeStringField("data_type", "NUMBER");
                        g.writeNumberField(value, (BigDecimal)this.data.get(i).getLast());
                        break;
                    }
                    case "String": 
                    case "DATE": 
                    case "TIMESTAMPTZ": 
                    case "TIMESTAMP": {
                        g.writeStringField(value, (String)this.data.get(i).getLast());
                        break;
                    }
                    case "CLOB": {
                        g.writeObjectField(value, this.data.get(i).getLast());
                    }
                }
                g.writeEndObject();
            }
        }
        catch (IOException e) {
            this.LOGGER.severe("Failure while generating POST\n" + e.getMessage());
            ExceptionUtil.throwSQLException(17001);
        }
        return g;
    }

    protected JsonGenerator batchHelper(String type, JsonGenerator g, LinkedList list) throws SQLException {
        try {
            g.writeArrayFieldStart("value");
            switch (type) {
                case "VARCHAR2": 
                case "VARCHAR": 
                case "CHAR": 
                case "DATE": 
                case "TIMESTAMP": 
                case "TIMESTAMPTZ": 
                case "DATALINK": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeString(list.get(i).toString());
                    }
                    break;
                }
                case "INTEGER": 
                case "NUMBER": {
                    for (int i = 0; i < list.size(); ++i) {
                        if (list.get(i) instanceof Integer) {
                            g.writeNumber(((Integer)list.get(i)).intValue());
                            continue;
                        }
                        if (!(list.get(i) instanceof Double)) continue;
                        g.writeNumber(((Double)list.get(i)).doubleValue());
                    }
                    break;
                }
                case "BOOLEAN": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeBoolean(((Boolean)list.get(i)).booleanValue());
                    }
                    break;
                }
                case "BIGDECIMAL": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeNumber((BigDecimal)list.get(i));
                    }
                    break;
                }
                case "FLOAT": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeNumber(((Float)list.get(i)).floatValue());
                    }
                    break;
                }
                case "DOUBLE": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeNumber(((Double)list.get(i)).doubleValue());
                    }
                    break;
                }
                case "CLOB": {
                    for (int i = 0; i < list.size(); ++i) {
                        g.writeString(list.get(i).toString());
                    }
                    break;
                }
            }
            g.writeEndArray();
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
            ExceptionUtil.throwSQLException(17001);
        }
        return g;
    }

    protected JsonGenerator processBatchSets(JsonGenerator g) throws SQLException {
        String value = "value";
        try {
            for (Object i : this.types.keySet()) {
                g.writeStartObject();
                if (i instanceof Integer) {
                    g.writeNumberField("index", ((Integer)i).intValue());
                } else if (i instanceof String) {
                    g.writeStringField("name", (String)i);
                }
                String data_type = this.types.get(i);
                if (!data_type.equals("DOUBLE") && !data_type.equals("BIGDECIMAL")) {
                    g.writeStringField("data_type", this.types.get(i));
                } else {
                    g.writeStringField("data_type", "NUMBER");
                }
                g.writeBooleanField("batch", true);
                g = this.batchHelper(data_type, g, this.data.get(i));
                g.writeEndObject();
            }
        }
        catch (IOException e) {
            this.LOGGER.severe("Exception while generating Json POST request\n" + e.getMessage());
            ExceptionUtil.throwSQLException(17001);
        }
        return g;
    }

    protected void updateList(Object parameterIndex, Object x) {
        if (this.data.containsKey(parameterIndex)) {
            if (this.batchIndex >= this.data.get(parameterIndex).size()) {
                this.data.get(parameterIndex).add(this.batchIndex, x);
            } else {
                this.data.get(parameterIndex).set(this.batchIndex, x);
            }
        } else {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(this.batchIndex, x);
            this.data.put(parameterIndex, list);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.LOGGER.finest("Setting Null");
        this.updateList(parameterIndex, null);
        this.types.put(parameterIndex, OracleTypes.getSQLTypeName(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.LOGGER.finest("Setting Boolean");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "BOOLEAN");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.LOGGER.finest("Setting byte");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "NUMBER");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.LOGGER.finest("Setting Short");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "NUMBER");
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.LOGGER.finest("Setting Int");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "INTEGER");
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.LOGGER.finest("Setting Long");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "NUMBER");
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.LOGGER.finest("Setting Float");
        this.updateList(parameterIndex, Float.valueOf(x));
        this.types.put(parameterIndex, "FLOAT");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.LOGGER.finest("Setting Double");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "DOUBLE");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.LOGGER.finest("Setting BigDecimal");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "BIGDECIMAL");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.LOGGER.finest("Setting String");
        this.updateList(parameterIndex, x);
        this.types.put(parameterIndex, "VARCHAR");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.LOGGER.finest("Setting Date");
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setDate(x, this.conn.getTimeZoneID(), cal));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.LOGGER.finest("Setting Time");
        String timeZoneID = this.conn.getTimeZoneID();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTime(x, timeZoneID, cal));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.LOGGER.finest("Setting Timestamp");
        String timeZoneID = this.conn.getTimeZoneID();
        Calendar defaultCal = Calendar.getInstance(TimeZone.getDefault());
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTimeStamp(x, timeZoneID, defaultCal));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.LOGGER.finest("Setting Date");
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setDate(x, this.conn.getTimeZoneID(), cal));
        this.types.put(parameterIndex, "DATE");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        String timeZoneID = this.conn.getTimeZoneID();
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTime(x, timeZoneID, cal));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.LOGGER.finest("Setting Timestamp with Calendar");
        String timeZoneID = this.conn.getTimeZoneID();
        DateTimestampsUtil ts = new DateTimestampsUtil();
        this.updateList(parameterIndex, ts.setTimeStamp(x, timeZoneID, cal));
        this.types.put(parameterIndex, "TIMESTAMP");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.LOGGER.finest("Setting Clob");
        this.updateList(parameterIndex, x.getSubString(1L, (int)x.length()));
        this.types.put(parameterIndex, "CLOB");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.LOGGER.finest("Setting URL");
        this.updateList(parameterIndex, x.toString());
        this.types.put(parameterIndex, "VARCHAR2");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        this.types.clear();
        this.data.clear();
    }

    protected Map<Object, LinkedList<Object>> getData() {
        return this.data;
    }

    protected Map<Object, String> getTypes() {
        return this.types;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof InputStream) {
            this.setAsciiStream(parameterIndex, (InputStream)x);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        if (this.outParams) {
            int errorCode = 17090;
            throw new SQLException(RestjdbcResources.getString("ORA_17090") + " Stored procedure with out or inout parameters cannot be batched", SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        this.batch = true;
        ++this.batchIndex;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch = false;
        this.batchIndex = 0;
        this.cmds.clear();
    }

    @Override
    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            ExceptionUtil.throwSQLException(17009);
        }
        if (this.conn.isClosed()) {
            ExceptionUtil.throwSQLException(17008);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        ExceptionUtil.throwSQLException("setCursorName(String name)", "PreparedStatement");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getResultSetConcurrency()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getMoreResults(int current)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getGeneratedKeys()", this.getClass().getSimpleName()));
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        this.LOGGER.info(RestjdbcResources.get("RESTJDBC_024"));
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setHoldability(int holdability)", this.getClass().getSimpleName()));
    }

    @Override
    public void cancel() throws SQLException {
        ExceptionUtil.throwSQLException("cancel()", "PreparedStatement");
    }

    @Override
    public void clearWarnings() throws SQLException {
        ExceptionUtil.throwSQLException("clearWarnings()", "PreparedStatement");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getMoreResults()", this.getClass().getSimpleName()));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ExceptionUtil.throwSQLException("setUnicodeStream(int parameterIndex, InputStream x, int length)", "PreparedStatement");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ExceptionUtil.throwSQLException("setBinaryStream(int parameterIndex, InputStream x, int length)", "PreparedStatement");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ExceptionUtil.throwSQLException("setBytes(int parameterIndex, byte[] x)", "PreparedStatement");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ExceptionUtil.throwSQLException("setObject(int parameterIndex, Object x, int targetSqlType)", "PreparedStatement");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ExceptionUtil.throwSQLException("setCharacterStream(int parameterIndex, Reader reader, int length)", "PreparedStatement");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        ExceptionUtil.throwSQLException("setRef(int parameterIndex, Ref x)", "PreparedStatement");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        ExceptionUtil.throwSQLException("setBlob(int parameterIndex, Blob x)", "PreparedStatement");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        ExceptionUtil.throwSQLException("setArray(int parameterIndex, Array x)", "PreparedStatement");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getMetaData()", this.getClass().getSimpleName()));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "executeUpdate(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName()));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "executeUpdate(String sql, int[] columnIndexes)", this.getClass().getSimpleName()));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "executeUpdate(String sql, String[] columnNames)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "execute(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "execute(String sql, int[] columnIndexes)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "execute(String sql, String[] columnNames)", this.getClass().getSimpleName()));
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getMaxFieldSize()", this.getClass().getSimpleName()));
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        ExceptionUtil.throwSQLException("setMaxFieldSize(int max)", "PreparedStatement");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getQueryTimeout()", this.getClass().getSimpleName()));
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        ExceptionUtil.throwSQLException("setQueryTimeout(int seconds)", "PreparedStatement");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        LogUtil.logOrException(this.getConnection(), null, "PreparedStatement.getWarnings() not supported", null);
        return null;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        ExceptionUtil.throwSQLException("setNull(int parameterIndex, int sqlType, String typeName)", "PreparedStatement");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getParameterMetaData()", this.getClass().getSimpleName()));
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        ExceptionUtil.throwSQLException("setRowId(int parameterIndex, RowId x)", "PreparedStatement");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        ExceptionUtil.throwSQLException("setNString(int parameterIndex, String value)", "PreparedStatement");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setNCharacterStream(int parameterIndex, Reader value, long length)", "PreparedStatement");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        ExceptionUtil.throwSQLException("setNClob(int parameterIndex, NClob value)", "PreparedStatement");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setClob(int parameterIndex, Reader reader, long length)", "PreparedStatement");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setBlob(int parameterIndex, InputStream inputStream, long length)", "PreparedStatement");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setNClob(int parameterIndex, Reader reader, long length)", "PreparedStatement");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        ExceptionUtil.throwSQLException("setSQLXML(int parameterIndex, SQLXML xmlObject)", "PreparedStatement");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        ExceptionUtil.throwSQLException("(int parameterIndex, Object x, int targetSqlType,int scaleOrLength)", "PreparedStatement");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.LOGGER.finest("Setting AsciiStream");
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            int bytes;
            if (length < 0L) {
                int error_code = 17068;
                String message = RestjdbcResources.getString("ORA_17068") + ": " + RestjdbcResources.getString("RESTJDBC_019");
                throw new SQLException(message, SQLStateMapping.getSQLState(error_code), error_code);
            }
            StringBuilder sb = new StringBuilder();
            for (long bytesRead = 0L; bytesRead < length && (bytes = x.read()) >= 0; ++bytesRead) {
                sb.append((char)bytes);
            }
            this.updateList(parameterIndex, sb.toString());
            this.types.put(parameterIndex, "VARCHAR");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
            ExceptionUtil.throwSQLException(17001);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setBinaryStream(int parameterIndex, InputStream x, long length)", "PreparedStatement");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        ExceptionUtil.throwSQLException("setCharacterStream(int parameterIndex, Reader reader, long length)", "PreparedStatement");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            StringBuilder sb = new StringBuilder();
            int bytes = 0;
            while (bytes != -1 && (bytes = x.read()) >= 0) {
                sb.append((char)bytes);
            }
            this.updateList(parameterIndex, sb.toString());
            this.types.put(parameterIndex, "CLOB");
        }
        catch (IOException ioe) {
            this.LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        ExceptionUtil.throwSQLException("setBinaryStream(int parameterIndex, InputStream x)", "PreparedStatement");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        ExceptionUtil.throwSQLException("setCharacterStream(int parameterIndex, Reader reader)", "PreparedStatement");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ExceptionUtil.throwSQLException("setNCharacterStream(int parameterIndex, Reader value)", "PreparedStatement");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        ExceptionUtil.throwSQLException("setClob(int parameterIndex, Reader reader)", "PreparedStatement");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        ExceptionUtil.throwSQLException("setBlob(int parameterIndex, InputStream inputStream)", "PreparedStatement");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        ExceptionUtil.throwSQLException("setNClob(int parameterIndex, Reader reader)", "PreparedStatement");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "unwrap(Class<T> iface)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "isWrapperFor(Class<?> iface)", this.getClass().getSimpleName()));
    }
}

