/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;

public class DateTimestampsUtil {
    public Timestamp getTimestamp(String tsStr, String timeZoneID) {
        Calendar utcCal = new GregorianCalendar();
        utcCal = DatatypeConverter.parseDateTime((String)tsStr);
        Long ts = utcCal.getTimeInMillis();
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getTimeZone(timeZoneID));
        format.format(ts);
        Calendar cal = format.getCalendar();
        boolean sendToAdhoc = false;
        String timestampStr = this.getTimestampStr(cal, sendToAdhoc);
        Timestamp timestamp = Timestamp.valueOf(timestampStr);
        return timestamp;
    }

    public Date getDate(String tsStr, String timeZoneID) {
        Timestamp timestamp = this.getTimestamp(tsStr, timeZoneID);
        Date date = new Date(timestamp.getTime());
        return date;
    }

    public Date getDate(String tsStr) throws SQLException {
        return Date.valueOf(tsStr);
    }

    public String setTimeStamp(Timestamp ts, String timeZoneID, Calendar cal) {
        cal.setTimeInMillis(ts.getTime());
        Calendar utcCal = Calendar.getInstance();
        utcCal.setTimeZone(TimeZone.getTimeZone(timeZoneID));
        utcCal.set(1, cal.get(1));
        utcCal.set(2, cal.get(2));
        utcCal.set(5, cal.get(5));
        utcCal.set(11, cal.get(11));
        utcCal.set(12, cal.get(12));
        utcCal.set(13, cal.get(13));
        utcCal.set(14, cal.get(14));
        utcCal.getTimeInMillis();
        utcCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        String iso_8601Str = this.getTimestampStr(utcCal, true);
        return iso_8601Str;
    }

    public String setDate(Date date, String timeZoneID, Calendar cal) {
        Timestamp ts = new Timestamp(date.getTime());
        return this.setTimeStamp(ts, timeZoneID, cal);
    }

    public String setTime(Time time, String timeZoneID, Calendar cal) {
        Timestamp ts = new Timestamp(time.getTime());
        return this.setTimeStamp(ts, timeZoneID, cal);
    }

    protected String getTimestampStr(Calendar cal, boolean sendToAdhoc) {
        StringBuilder sb = new StringBuilder();
        sb.append(cal.get(1));
        sb.append('-');
        if (cal.get(2) < 9) {
            sb.append('0');
        }
        sb.append(cal.get(2) + 1);
        sb.append('-');
        if (cal.get(5) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(5));
        if (sendToAdhoc) {
            sb.append('T');
        } else {
            sb.append(' ');
        }
        if (cal.get(11) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(11));
        sb.append(':');
        if (cal.get(12) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(12));
        sb.append(':');
        if (cal.get(13) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(13));
        sb.append('.');
        int millis = cal.get(14);
        if (millis < 10) {
            sb.append("00");
        } else if (millis < 100) {
            sb.append('0');
        }
        sb.append(millis);
        if (sendToAdhoc) {
            sb.append('Z');
        }
        return sb.toString();
    }

    public Timestamp getTimestamp(String tsStr, String timeZoneID, Calendar cal) {
        GregorianCalendar local = new GregorianCalendar(TimeZone.getDefault());
        Timestamp rsTimestamp = this.getTimestamp(tsStr, timeZoneID);
        local.setTimeInMillis(rsTimestamp.getTime());
        cal.set(1, local.get(1));
        cal.set(2, local.get(2));
        cal.set(5, local.get(5));
        cal.set(11, local.get(11));
        cal.set(12, local.get(12));
        cal.set(13, local.get(13));
        cal.set(14, local.get(14));
        return new Timestamp(cal.getTimeInMillis());
    }

    public Date getDate(String tsStr, String timeZoneID, Calendar cal) {
        Timestamp timestamp = this.getTimestamp(tsStr, timeZoneID, cal);
        Date date = new Date(timestamp.getTime());
        return date;
    }

    public Time getTime(String tsStr) {
        return Time.valueOf(tsStr);
    }

    public Time getTime(String tsStr, String timeZoneID, Calendar cal) {
        GregorianCalendar local = new GregorianCalendar(TimeZone.getDefault());
        Timestamp rsTimestamp = this.getTimestamp(tsStr, timeZoneID);
        local.setTimeInMillis(rsTimestamp.getTime());
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, local.get(11));
        cal.set(12, local.get(12));
        cal.set(13, local.get(13));
        cal.set(14, local.get(14));
        return new Time(cal.getTimeInMillis());
    }
}

