<?xml version="1.0" ?>
<!-- 
NAME
    cmkurollbk.xsl
DESCRIPTION
    Convert mdapi ROLLBACK_T document to CMXML ROLLBACK document
    Remove elements that do not need comparing	

MODIFIED	MM/DD/YY
    pkalire 05/15/08 - Merge 11GC functionality
    xshen   09/22/04 - add compare options
    ngade   08/27/04 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkustorage.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
 <xsl:for-each select="ROW">
  <xsl:apply-templates/>
 </xsl:for-each>
</xsl:template>

<xsl:template match="ROLLBACK_T">
  <ROLLBACK_SEGMENTS>
    <NAME>
      <xsl:value-of select="NAME"/>
    </NAME>
    <xsl:choose>
      <xsl:when test = "USER_NUM=1">
        <PUBLIC>
          <xsl:text>Y</xsl:text>
        </PUBLIC>
      </xsl:when>
      <xsl:otherwise>
        <PUBLIC>
          <xsl:text>N</xsl:text>
        </PUBLIC>
      </xsl:otherwise>
    </xsl:choose>
  <xsl:if test="$IGNORE_TABLESPACE=0">
    <TABLESPACE>
      <xsl:value-of select="TABLESPACE/NAME"/>
    </TABLESPACE>
  </xsl:if>
    <xsl:call-template name="DoStorage">
     <xsl:with-param name="BlkSize" select="TABLESPACE/BLOCKSIZE"/>
     <xsl:with-param name="ParentNode"    select="current()"/>
    </xsl:call-template>
  </ROLLBACK_SEGMENTS>
</xsl:template>
</xsl:stylesheet>
