<?xml version="1.0"?>
<!--

 Copyright (c) 2006, 2012, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuaseq.xsl
DESCRIPTION
    Convert sxml SEQUENCE diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge      06/29/12 - Fix xmlns attribute problem
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    lbarton     12/29/06 - more features
    rapayne     06/09/06 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="sxml:SEQUENCE">
  <!-- *******************************************************************
Template: SEQUENCE - top-level template for sequences.
******************************************************************** -->
  <xsl:element name="ALTER_XML" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">SEQUENCE</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2  -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <xsl:element name="ALTER_LIST_ITEM">
     <xsl:if test="$PRS_NAME=1 or 
                   $PRS_ALTERABLE=1 or
                   $PRS_XPATH=1">
      <xsl:element name="PARSE_LIST">
       <xsl:call-template name="AddXPathParseItem">
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_NAME"/>
        <xsl:with-param name="Item">NAME</xsl:with-param>
        <xsl:with-param name="Value1">
         <xsl:choose>
          <xsl:when test="sxml:NAME[@value1]">
           <xsl:value-of select="sxml:NAME/@value1"/>
          </xsl:when>
          <xsl:otherwise>
           <xsl:value-of select="sxml:NAME"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AddParseItem">
        <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
        <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
        <xsl:with-param name="Value1">
         <xsl:if test="sxml:NAME[@value1]">NAME</xsl:if>
        </xsl:with-param>
        <xsl:with-param name="Value2">
         <xsl:if test="sxml:START_WITH[@value1]">START_WITH</xsl:if>
        </xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
     <xsl:element name="SQL_LIST">
      <xsl:element name="SQL_LIST_ITEM">
       <xsl:element name="TEXT">
        <xsl:text>ALTER SEQUENCE </xsl:text>
        <xsl:call-template name="SchemaName">
         <xsl:with-param name="ParentNode" select="."/>
        </xsl:call-template>
        <xsl:if test="sxml:INCREMENT[@value1]">
         <xsl:text> INCREMENT BY </xsl:text>
         <xsl:value-of select="sxml:INCREMENT"/>
        </xsl:if>
        <xsl:if test="sxml:MINVALUE[@value1]">
         <xsl:text> MINVALUE </xsl:text>
         <xsl:value-of select="sxml:MINVALUE"/>
        </xsl:if>
        <xsl:if test="sxml:MAXVALUE[@value1]">
         <xsl:choose>
          <xsl:when test="sxml:MAXVALUE='999999999999999999999999999'">
           <xsl:text> NOMAXVALUE </xsl:text>
          </xsl:when>
          <xsl:otherwise>
           <xsl:text> MAXVALUE </xsl:text>
           <xsl:value-of select="sxml:MAXVALUE"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:if>
        <xsl:if test="sxml:CYCLE/@src='1'"> NOCYCLE</xsl:if>
        <xsl:if test="sxml:CYCLE/@src='2'"> CYCLE</xsl:if>
        <xsl:if test="sxml:CACHE[@value1]">
         <xsl:choose>
          <xsl:when test="sxml:CACHE='0'">
           <xsl:text> NOCACHE</xsl:text>
          </xsl:when>
          <xsl:otherwise>
           <xsl:text> CACHE </xsl:text>
           <xsl:value-of select="sxml:CACHE"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:if>
        <xsl:if test="sxml:ORDER/@src='1'"> NOORDER</xsl:if>
        <xsl:if test="sxml:ORDER/@src='2'"> ORDER</xsl:if>
       </xsl:element>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:element>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
