-- SELECT *
--   FROM 
--       ORAPERF.S_PARTY T1, <-- full table ref
--       S_EVT_ACT T18,      <-- full table ref
--       T20,                 <-- "simple table ref"
--       ORAPERF.S_PARTY,     <-- "simple table ref"
"simple table ref": 
--"narrowest qb".query_block <= alias &
[alias) table_reference &
([alias) identifier | [alias) query_table_expression ) &
table = alias
;

"full table ref":
--"narrowest qb".query_block <= alias &
[alias-1) query_table_expression &
[alias) identifier &
table = alias-1
;

"table ref in update":
[alias-1) dml_table_expression_clause &
[alias) identifier &
table = alias-1
-> {
    //print(tuple);
}

"table ref in insert":
[alias) dml_table_expression_clause &
[alias) identifier & ![alias+1) identifier &
table = alias
;


"table_alias in narrowest qb" : "full table ref"
                              | "simple table ref"
                              | "table ref in update"
                              | "table ref in insert"
-> {
    //print(tuple);
}

functions: [name) name_wo_function_call
          & name) < :offset
;

lastFunction: //name(functions)
-> {
    var node = tuple.get("name");
    var name = target.getInput().substring(target.src.get(node.from).begin,target.src.get(node.to-1).end);
    struct.lastFunctionCallName = name;
}          

