+++++ Very simple injection
Injection true
Dataflow d1:1 d1:5

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || d1  INTO val; 
 RETURN val;
END;
/

+++++ Numbers safe
Injection false

CREATE OR REPLACE FUNCTION sample (n1 NUMBER, n2 PLS_INTEGER, n3 BINARY_DOUBLE, n4 BINARY_FLOAT, n5 BINARY_INTEGER)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || n1 || n2 || n3 || n4 || n5 INTO val; 
 RETURN val;
END;
/

+++++ Assigning to number makes safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  num1 NUMBER;
BEGIN
 num1 := d1;  -- Injection with NLS is not totally impossible, but requires substantial other access to exploit ; for now, this is safe
 execute immediate 'SELECT count(1) FROM ' || num1  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.ENQUOTE_LITERAL output is safe (direct)
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.enquote_literal(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.ENQUOTE_LITERAL output is safe (assigned)
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  v1  VARCHAR2(100);
BEGIN
 v1 := dbms_assert.enquote_literal(d1);
 execute immediate 'SELECT count(1) FROM ' || v1 INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.ENQUOTE_NAME output is safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val1 NUMBER;
  val2 NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.enquote_name(d1)  INTO val1; 
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.enquote_name(d1, TRUE)  INTO val2; 
 RETURN val1 + val2;
END;
/

+++++ DBMS_ASSERT.ENQUOTE_NOOP output is treated as safe (varchar)
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.noop(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.ENQUOTE_NOOP output is treated as safe (CLOB)
Injection false

CREATE OR REPLACE FUNCTION sample (d1 CLOB)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.noop(d1)  INTO val; 
 RETURN val;
END;
/


+++++ Function calls can return any exception
Injection true
Dataflow D1:1 D1:-16 D1:18

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
BEGIN
  t1 := dbms_assert.noop(d1);  -- Treat as safe; if viewed as throwing, d1 would be dangerous in exception handler
  quotient := numerator / denominator;
  return quotient;
  EXCEPTION
    WHEN VALUE_ERROR OR STORAGE_ERROR THEN
      return 0;
    WHEN ZERO_DIVIDE THEN
      return 0;
    WHEN OTHERS THEN
      -- Since dbms_assert.noop is a function, it could throw any exception
      execute immediate 'SELECT count(1) FROM ' || d1  INTO quotient; 
      RETURN quotient;
END;
/

+++++ DBMS_ASSERT.QUALIFIED_SQL_NAME output is safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.qualified_sql_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.QUALIFIED_SQL_NAME throws if unsafe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  unused VARCHAR2(100);
BEGIN
 unused := dbms_assert.QUALIFIED_SQL_NAME(d1);
 -- d1 safe if we reach here
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.qualified_sql_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ Handles PRAGMA EXCEPTION_INIT
Injection true
Dataflow D1:1 D1:-15 D1:16

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
  ASSERT_EXCEPTION EXCEPTION;
  PRAGMA EXCEPTION_INIT(ASSERT_EXCEPTION, -44004);
BEGIN
  t1 := dbms_assert.QUALIFIED_SQL_NAME(d1);  -- Unclean if throws
  denominator := d1;		-- Implicit conversion
  quotient := numerator / denominator;
  return quotient;
  EXCEPTION
    WHEN ASSERT_EXCEPTION THEN
      execute immediate 'SELECT count(1) FROM ' || d1  INTO quotient; 
      RETURN quotient;
    WHEN OTHERS THEN
      RETURN 0;
END;
/

+++++ DBMS_ASSERT.QUALIFIED_SQL_NAME may throw exception (dangerous in throw)
Injection true
Dataflow D1:1 D1:-15 D1:16

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
BEGIN
  t1 := dbms_assert.QUALIFIED_SQL_NAME(d1);  -- Unclean if throws
  denominator := d1;		-- Implicit conversion
  quotient := numerator / denominator;
  return quotient;
  EXCEPTION
    WHEN VALUE_ERROR OR STORAGE_ERROR THEN
      RETURN 0; 
    WHEN OTHERS THEN
      execute immediate 'SELECT count(1) FROM ' || d1  INTO quotient; 
      RETURN quotient;
END;
/

+++++ DBMS_ASSERT.SCHEMA_NAME output is safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.qualified_sql_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.SCHEMA_NAME throws if unsafe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  unused VARCHAR2(100);
BEGIN
 unused := dbms_assert.qualified_sql_name(d1);
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.schema_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.SIMPLE_SQL_NAME output is safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.SIMPLE_SQL_NAME(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.SIMPLE_SQL_NAME throws if unsafe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  unused VARCHAR2(100);
BEGIN
 unused := dbms_assert.qualified_sql_name(d1);
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.simple_sql_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.SQL_OBJECT_NAME output is safe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
BEGIN
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.sql_object_name(d1)  INTO val; 
 RETURN val;
END;
/

+++++ DBMS_ASSERT.SQL_OBJECT_NAME throws if unsafe
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  unused VARCHAR2(100);
BEGIN
 unused := dbms_assert.sql_object_name(d1);
 execute immediate 'SELECT count(1) FROM ' || dbms_assert.sql_object_name(d1)  INTO val; 
 RETURN val;
END;
/


+++++ Assignment clearing var
Injection false

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 IF (tabName != 'PRICE') THEN
   t3 := t2;
 ELSE
   t3 := 'COST_TABLE';
 END IF;
 t3 := 'COST_TABLE'; -- Safe!
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/

+++++ If - all branches clean
Injection false

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 t3 := t2;
 IF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE'; 
 ELSIF (tabName = 'PRICE') THEN
   t3 := 'COST_TABLE';
 ELSE
   t3 := 'COST_TABLE';
 END IF;
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/

+++++ If - then branch, no else
Injection true
Dataflow TABNAME:1 T2:9 T3:10 T3:-11 T3:14

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 t3 := t2;
 IF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE';
 END IF;
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/

+++++ If - then branch
Injection true
Dataflow tabName:1 T2:9 T3:11 T3:-10 T3:17

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 IF (tabName != 'PRICE') THEN
   t3 := t2;
 ELSIF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE';
 ELSE
   t3 := 'COST_TABLE'; -- Does not make t3 safe outside of this block
 END IF;
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/

+++++ If - elsif branch
Injection true
Dataflow TABNAME:1 T2:9 T3:13 T3:-10 T3:17

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 IF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE';
 ELSIF (tabName != 'PRICE') THEN
   t3 := t2;
 ELSE
   t3 := 'COST_TABLE';
 END IF;
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/

+++++ If - else branch
Injection true
Dataflow tabName:1 t2:9 t3:15 t3:-10 t3:17

CREATE OR REPLACE FUNCTION getCountFromTable ( tabName VARCHAR2)
RETURN NUMBER IS
 val NUMBER;
 t1 VARCHAR2(100);
 t2 VARCHAR2(100);
 t3 VARCHAR2(100);
BEGIN
 t1 := tabName || '_table';
 t2 := upper(tabName);
 IF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE'; -- Does not make t3 safe outside of this block
 ELSIF (tabName != 'PRICE') THEN
   t3 := 'COST_TABLE'; -- Does not make t3 safe outside of this block
 ELSE
   t3 := t2;
 END IF;
 execute immediate 'SELECT count(1) FROM ' || t3 
 INTO val;
 RETURN val;
END;
/


+++++ LOOP - infinite loop with unreachable statement
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  LOOP
 	t3 := d1;
  END LOOP;	-- Infinite loop; select is unrechable and thus safe
  execute immediate 'SELECT count(1) FROM ' || t3 INTO val;
  RETURN val;
END;
/


+++++ LOOP - with EXITInjection true
Dataflow d1:1 d1:-8 t3:12 t3:-8 t3:-13 t3:14

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  LOOP
	IF (t3 = d1) THEN
      EXIT;
    END IF;  
 	t3 := d1;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3 INTO val; 
 RETURN val;
END;
/

+++++ LOOP - with EXIT WHEN 
Injection true
Dataflow d1:1 d1:-8 t3:10 t3:-8 t3:-11 t3:12

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  LOOP
	EXIT WHEN (t3 = d1);
 	t3 := d1;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - data flow from EXIT - EXIT is protected by assignment 
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
       t3 := 'SAFE';
       EXIT;
    END IF;
 	t3 := d1;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - data flow from EXIT - not all exits protected
Injection true
Dataflow d1:1 d1:-9 t3:17 t3:-9 t3:-18 t3:19

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
       t3 := 'SAFE';
       EXIT;
    ELSIF (val = 7) THEN
       EXIT;
    END IF ;
 	t3 := d1;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - data flow from EXIT - changed var not used above any explicit EXIT
Injection true
Dataflow d1:1 d1:-9 t3:17 t3:-9 t3:-19 t3:20

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
       t2 := 'ALSO SAFE';
       EXIT;
    ELSIF (val = 7) THEN
       EXIT;
    END IF ;
 	t3 := d1;
 	t2 := 'SAFE';
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3 || t2  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - data flow from EXIT - local variable hides dangerous real one
Injection true
Dataflow d1:1 d1:-9 t3:22 t3:-9 t3:-23 t3:24

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
       DECLARE
         t3 VARCHAR2(100);
       BEGIN
         t3 := 'SAFE';
         EXIT;
       END;
    ELSIF (val = 7) THEN
       t3 := 'SAFE';
       EXIT;
    END IF;
 	t3 := d1;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - data flow from EXIT - local variable hides safe real one
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
       DECLARE
         t3 VARCHAR2(100);
       BEGIN
         t3 := d1;
         EXIT;
       END;
    ELSIF (val = 7) THEN
       EXIT;
    END IF;
 	t3 := 'SAFE';
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - CONTINUE propagates unsafe value
Injection true
Dataflow d1:1 d1:-9 t3:14 t3:-9 t3:-19 t3:20

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
         EXIT;
    END IF;
    t3 := d1;
    IF (val = 7) THEN
    		CONTINUE;
    END IF;
 	t3 := 'SAFE';
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ LOOP - CONTINUE WHEN propagates unsafe value
Injection true
Dataflow d1:1 d1:-9 t3:14 t3:-9 t3:-17 t3:18

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    IF (val = 5) THEN
         EXIT;
    END IF;
    t3 := d1;
  	CONTINUE WHEN (val = 7);
 	t3 := 'SAFE';
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/




+++++ LOOP - CONTINUE is safe when EXIT wouldn't be
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  LOOP
    val := val + 1;
    t3 := d1;
    IF (val = 7) THEN
    		CONTINUE;
    END IF;
 	t3 := 'SAFE';
    IF (val = 5) THEN
         EXIT;
    END IF;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/

+++++ WHILE 
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  val := 1;
  WHILE val < 10 LOOP
    val := val + 1;
    t3 := d1;
    IF (val = 7) THEN
    		CONTINUE;
    END IF;
 	t3 := 'SAFE';
    IF (val = 5) THEN
         EXIT;
    END IF;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ FOR
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  t1 := d1;
  FOR t1 IN 1 .. 10 LOOP    -- Hides t1
    t3 := t1;		-- Promotes integer loop index "t1", not VARCHAR2 "t1"
    IF (t1 = 7) THEN
    		CONTINUE;
    END IF;
    IF (t1 = 5) THEN
         EXIT;
    END IF;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ FOR REVERSE
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  t1 := d1;
  FOR t1 IN REVERSE 10 .. 1 LOOP    -- Hides t1
    t3 := t1;		-- Promotes integer loop index "t1", not VARCHAR2 "t1"
    IF (t1 = 7) THEN
    		CONTINUE;
    END IF;
    IF (t1 = 5) THEN
         EXIT;
    END IF;
 END LOOP;
 execute immediate 'SELECT count(1) FROM ' || t3  INTO val; 
 RETURN val;
END;
/


+++++ Local scope isolates dangerous var
KNOWNBAD
Injection false

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  t1 := 'SAFE';
  DECLARE
    t1 VARCHAR2(50);
  BEGIN
    t1 := d1;
  END;

 execute immediate 'SELECT count(1) FROM ' || t1  INTO val; 
 RETURN val;
END;
/


+++++ Local scope does not hide dangerous assignment
KNOWNBAD
Injection true
Dataflow d1:1 t1:8 t1:14

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  val NUMBER;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  t1 := d1;
  DECLARE
    t1 VARCHAR2(50);
  BEGIN
    t1 := 'SAFE';
  END;
 execute immediate 'SELECT count(1) FROM ' || t1  INTO val; 
 RETURN val;
END;
/


+++++ Exception possible at any assignment
Injection true
Dataflow d1:1 t1:9 (VALUE_ERROR):10 t1:-12 t1:13

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  othernum NUMBER;
  val NUMBER := 1;
  t1 VARCHAR2(100);
  t2 VARCHAR2(100);
  t3 VARCHAR2(100);
BEGIN
  t1 := d1;		-- Exception possible here (d1 > 100 chars)
  t1 := 'SAFE'; -- Exception possible here (PROGRAM_ERROR, OUT_OF_MEMORY) ... alas.
  return val;
  EXCEPTION WHEN OTHERS THEN
  execute immediate 'SELECT count(1) FROM ' || t1  INTO val; 
  RETURN val;
END;
/


+++++ Exception - ZERO_DIVIDE
Injection true
Dataflow d1:1 t1:9 (ZERO_DIVIDE):10 t1:-14 t1:15

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
BEGIN
  denominator := d1;		-- Implicit conversion
  t1 := d1;
  quotient := numerator / denominator;
  t1 := 'SAFE';
  return quotient;
  EXCEPTION
    WHEN ZERO_DIVIDE THEN
      execute immediate 'SELECT count(1) FROM ' || t1  INTO quotient; 
      RETURN quotient;
    WHEN OTHERS THEN
      return 0;
END;
/


+++++ Exception - Data from normal exit gets flowed
start
Injection true
Dataflow d1:1 t1:9 t1:16

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
BEGIN
  BEGIN
    t1 := d1;
	denominator := d1;		-- Implicit conversion
	quotient := numerator / denominator;
	EXCEPTION
	  WHEN ZERO_DIVIDE THEN
	  t1 := 'SAFE';
   END;
   execute immediate 'SELECT count(1) FROM ' || t1  INTO quotient; 
   RETURN quotient;
END;
/


+++++ Exception - Data from exception handler gets flowed
KNOWNBAD
Injection true
Dataflow d1:1 t1:9 (ZERO_DIVIDE):10 t1:-14 t1:15

CREATE OR REPLACE FUNCTION sample (d1 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1 VARCHAR2(100);
BEGIN
  BEGIN
    t1 := 'SAFE';
	denominator := d1;		-- Implicit conversion
	quotient := numerator / denominator;
	return quotient;
	EXCEPTION
	  WHEN ZERO_DIVIDE THEN
	  t1 := d1;
  END;
  execute immediate 'SELECT count(1) FROM ' || t1  INTO quotient; 
  RETURN quotient;
END;
/


+++++ Exception - Nested exception scopes - proves nothing, DELETE THIS TEST
knownbad
Injection false

-- From https://docs.oracle.com/cd/B14117_01/appdev.101/b10807/07_errs.htm
DECLARE
   past_due EXCEPTION;
   acct_num NUMBER;
BEGIN
   DECLARE  ---------- sub-block begins
      past_due EXCEPTION;  -- this declaration prevails
      acct_num NUMBER;
     due_date DATE := SYSDATE - 1;
     todays_date DATE := SYSDATE;
   BEGIN
      IF due_date < todays_date THEN
         RAISE past_due;  -- this is not the same as the exterior past_due; caught by OTHERS
      END IF;
   END;  ------------- sub-block ends
EXCEPTION
   WHEN past_due THEN  -- does not handle RAISEd exception
      dbms_output.put_line('Handling PAST_DUE exception.');
   WHEN OTHERS THEN
     dbms_output.put_line('Could not recognize PAST_DUE_EXCEPTION in this scope.');
END;
/


+++++ Exception - user-declared exception; interior hides exterior
SKIP
Knownbad
Injection true

-- Modified from https://docs.oracle.com/cd/B14117_01/appdev.101/b10807/07_errs.htm
CREATE OR REPLACE PROCEDURE sampleproc (
  d1 VARCHAR2,
  d2 VARCHAR2
)
IS
   past_due EXCEPTION;
   acct_num NUMBER;
BEGIN
   DECLARE
      past_due EXCEPTION; 
      acct_num NUMBER;
     due_date DATE := SYSDATE - 1;
     todays_date DATE := SYSDATE;
   BEGIN
      IF due_date < todays_date THEN
         RAISE past_due;  -- this is not handled
      END IF;
   END;
EXCEPTION
   WHEN past_due THEN  -- Verify which exception handles the raised exception
      execute immediate 'SELECT count(1) FROM ' || d1  INTO acct_num; 
   WHEN OTHERS THEN
      execute immediate 'SELECT count(1) FROM ' || d2  INTO acct_num; 
END;
/

+++++ GARBAGE - DELETE THIS
SKIP
Knownbad


Seed: D1$6 | D1$6
de-queueing D1$6 | D1$6
  Reached: T1$32 | D1$6 T1$32
  Reached: DENOMINATOR$37 | D1$6 DENOMINATOR$37
de-queueing T1$32 | D1$6 T1$32
de-queueing DENOMINATOR$37 | D1$6 DENOMINATOR$37
  Reached: QUOTIENT$42 | D1$6 DENOMINATOR$37 QUOTIENT$42
de-queueing QUOTIENT$42 | D1$6 DENOMINATOR$37 QUOTIENT$42
Checking sink T1$60
D1$6 <- -> T1$32 DENOMINATOR$37
NUMERATOR$15 <- -> QUOTIENT$42
T1$24 <- -> T1$60
T1$32 <- D1$6 ->
DENOMINATOR$37 <- D1$6 -> QUOTIENT$42
QUOTIENT$42 <- NUMERATOR$15 DENOMINATOR$37 ->
T1$60 <- T1$24 ->

CREATE OR REPLACE FUNCTION sample (d1$6 VARCHAR2)
RETURN NUMBER IS
  quotient NUMBER;
  numerator NUMBER := 1;
  denominator NUMBER;
  t1$24 VARCHAR2(100);
BEGIN
  BEGIN
    t1$32 := d1;
	denominator$37 := d1;		-- Implicit conversion
	quotient$42 := numerator / denominator;
	EXCEPTION
	  WHEN ZERO_DIVIDE THEN
	  t1 := 'SAFE';
   END;
   execute immediate 'SELECT count(1) FROM ' || t1  INTO quotient; 
   RETURN quotient;
END;
/



