/*
 * Recognize various nodes on parse tree
 * Simple conditions, like
   "sql_statement": [sql_statement) sql_statement;
   are handled automatically without need to list them explicitly
   (SqlRecognizer sees no sql_statement in this file, so it adds one)
 */

"procedureCall": [procedureCall) function | [procedureCall) procedure_call;

"queryBlock": [queryBlock) subquery;

"main QB" : \/queryBlock("queryBlock");  -- auxiliary predicate (which is not listed among recognized symbols)
"nested QB" : "queryBlock" - "main QB";  -- ditto

-- When extracting columns the main challenge is not to look inside nested subqueries, for example 
--
--SELECT
--  DEPARTMENT_ID,
-- (select ignore from T) as scalarSubquery
-- FROM EMP_DETAILS_VIEW
--
-- "columnSelect" lists [DEPARTMENT_ID, COUNT(*), (select ignore from T1 where 1=1)] but not "ignore"
-- Hence query in three steps
-- 1. "all columns" 
-- 2. "columns in nested QB"
-- 3. subtract one from the other (projected to the column of interest, first)
"all columns": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause < columnSelect
     & "main QB".queryBlock < select_clause
;

"columns in nested QB": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause < columnSelect
     & "nested QB".queryBlock < select_clause
;

"columnSelect": ([columnSelect]|"all columns") - ([columnSelect]|"columns in nested QB")
;

"all tables": [tableFrom) table_reference
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "main QB".queryBlock < from_clause
;

"tables in nested QB": [tableFrom) table_reference
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "nested QB".queryBlock < from_clause
;

"tableFrom":  ([tableFrom]|"all tables") - ([tableFrom]|"tables in nested QB");

commonTableExprNames: [cteName) colmapped_query_name
      & [tableFrom) table_reference
      & ?cteName = ?tableFrom
;

allTables:  ([tableFrom]|"all tables") - ([tableFrom]|commonTableExprNames)
->;


"all predicates": predicateWhere^ = where_clause
      & [where_clause) where_clause
      & [predicateWhere) condition
      & "main QB".queryBlock < where_clause
;

"predicates in nested QB": predicateWhere^ = where_clause
      & [where_clause) where_clause
      & [predicateWhere) condition
      & "nested QB".queryBlock < where_clause
;


"predicateWhere": ([predicateWhere]|"all predicates") - ([predicateWhere]|"predicates in nested QB")
;

"expr in orderBy": [order_by_clause) order_by_clause 
	  & order_by_clause < orderBy
	  &  [orderBy) expr
	  & [order_by_clause^) subquery
;
"allOrderBys": \/orderBy("expr in orderBy")  -- e.g. order by 1+2 --<-- don't want returning nested 1 and 2 
;
"nestedOrderBys": "nested QB".queryBlock < "allOrderBys".orderBy 
; 
"orderBy": "allOrderBys" - "nestedOrderBys";

"expr in groupBy": [group_by_clause) group_by_clause 
	  & group_by_clause < groupBy
	  &  [groupBy) expr
;
"allGroupBys": \/groupBy("expr in groupBy")  
;
"nestedGroupBys": "nested QB".queryBlock < "allGroupBys".groupBy 
; 
"groupBy": "allGroupBys" - "nestedGroupBys";

"arg":  "procedureCall".procedureCall < arg 
       & ([arg) string_literal | [arg) numeric_literal )
       & ([arg) expr | [arg) pls_expr )  -- 23246755: 
                                         -- SELECT SYS.XMLTYPE(xmlserialize(DOCUMENT XMLType('<poid>143598</poid>') AS
                                         -- CLOB indent size = 2)) "WORKFLOW_DATA"
                                         --                   ^^^ don't want this 
;

"user": [user) user;
"role": [role) revoke_system_privileges[3,18);

"assignedBind": [assignedBind) bind_var & [assignedBind^) assignment_stmt & [assignedBind = [(assignedBind^)
              | [assignedBind) bind_var & [assignedBind^) into_list & [assignedBind-1) 'INTO'
;

standalone_procs: [object_name) identifier   
           &    ([object_type) 'PROCEDURE' | [object_type) 'FUNCTION'  )    
           &   ( object_type = object_name-1
               | object_type = object_name-1
               | [object_name-1) '.' & object_type = object_name^-1
               | [object_name-1) '.' & object_type = object_name^-1
               )
           &    ([object_name^^^) create_plsql | [object_name^^^^) create_plsql | [object_name^^^) ff_wo_external)
;
packages_types:      [object_name) identifier 
           &    ([object_type) 'PACKAGE' | [object_type) 'TYPE' | [object_type) 'BODY' | [object_type) wrap  ) 
           & ![object_name+1) '.'   
           &   (  object_type = object_name-1
                | object_type = object_name-3
                | object_type = object_name^^
               )
           &    ( [object_name^^) create_plsql | [object_name^^^) create_plsql | [object_name^^^^) create_plsql)
; 
triggers:  [object_name) identifier & object_type = object_name-1
           &  (  [object_name^) trigger  & ![object_name+1) '.'
              |  [object_name^^) trigger & [object_name-1) '.' & ![object_name+1) '.'
              )
; 


allConstraints:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'CONSTRAINT' & ![object_name+1) '.'
             |  [object_name-3) 'CONSTRAINT' & [object_name-1) '.' & ![object_name+1) '.'
              )
; 
tableConstraints: [table) relational_table 
           & table < object_name
           & [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'CONSTRAINT' & ![object_name+1) '.'
             |  [object_name-3) 'CONSTRAINT' & [object_name-1) '.' & ![object_name+1) '.'
              )
;
constraints: allConstraints - tableConstraints
;

dimensions:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'DIMENSION' & ![object_name+1) '.'
              | [object_name-3) 'DIMENSION' & [object_name-1) '.' & ![object_name+1) '.'
              )
; 
synonyms:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'SYNONYM' & ![object_name+1) '.'
              | [object_name-3) 'SYNONYM' & [object_name-1) '.' & ![object_name+1) '.'
              )
;
sequences:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'SEQUENCE' & ![object_name+1) '.'
              | [object_name-3) 'SEQUENCE' & [object_name-1) '.' & ![object_name+1) '.'
              )
;  
tables:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'TABLE' & ![object_name+1) '.'
              | [object_name-3) 'TABLE' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & [object_name^) create_table
; 
views:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'VIEW' & ![object_name+1) '.'
              | [object_name-3) 'VIEW' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & ([object_name^) create_view | [object_name^) create_view#
             |[object_name^) create_materialized_view | [object_name+1) create_materialized_view[33,79) )
;
indexes:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'INDEX' & ![object_name+1) '.'
              | [object_name-3) 'INDEX' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & [object_name^) create_index_statement
;  

dblinks:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'LINK' & [object_name-2) 'DATABASE'
              | [object_name-2) 'LINK' & [object_name-3) 'DATABASE' & [object_name-1) create_database_link[41,48) 
              )
;  

scheduler_programs:  [object_name) arg & [object_name-1) '(' & [object_name^) paren_expr_list
               & call^=object_name^-1 & ?call ='dbms_Scheduler' & [call+1) '.' & (
                    ?object_type ='create_program' 
                  | ?object_type ='create_job' 
                  | ?object_type ='create_job_class' 
                  | ?object_type ='create_schedule'
                  | ?object_type ='create_window'
                ) & object_type = call+2
->{
  //print(tuple["object_name"])
}  


objects: standalone_procs | packages_types | triggers
       | constraints | dimensions | synonyms | sequences | dblinks
       | tables | views | indexes
       | scheduler_programs
->
;


references: [type) identifier & ( [type) constrained_type | [type) unconstrained_type )
      | [type) identifier & [type+1) '.' & ( [type^) constrained_type | [type^) unconstrained_type )
      | [type) identifier & [type^) adt_type_spec
      | [type) identifier & [type+1) '.' & [type^^) adt_type_spec
      | [type) identifier & [type+1) '.' & [type^^) default_expr_opt
->
;
