/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

/**
 * Feature information gathered from processing the <b>feature-hook</b> section
 * of the extension manifest. The information recorder here describes the
 * functionality an extension provides in a user visible way.
 */
public final class Feature
{
  private String _copyright;
  private String _description;
  private String _iconPath;  
  private String _license;
  private String _partOf;
  private boolean _isOptional;

  void setLicense( String license )
  {
    _license = license;
  }

  void setCopyright( String copyright )
  {
    _copyright = copyright;
  }


  void setIconPath( String iconPath )
  {
    _iconPath = iconPath;
  }


  
  void setDescription( String description )
  {
    _description = description;
  }
  

  void setOptional( boolean optional )
  {
    _isOptional = optional;
  }
  
  void setPartOf( String partOf )
  {
    _partOf = partOf;
  }

  /**
   * Gets the text of any license for this feature.
   * 
   * @return the text of any license for this feature. May return null if this
   *    feature does not have a license.
   */
  public String getLicense()
  {
    return _license;
  }
  
  /**
   * Gets a copyright message for this feature.
   * 
   * @return a copyright message for this feature. May return null if this 
   *    feature does not have a copyright message.
   */
  public String getCopyright()
  {
    return _copyright;
  }

  /**
   * Gets the path of an icon for this feature.
   * 
   * @return an icon used to represent this feature. May return null if this
   *    feature does not have an icon.
   */
  public String getIconPath()
  {
    return _iconPath;
  }
  
  /**
   * Gets a description of this feature.
   * 
   * @return a description of this feature. May return null.
   */
  public String getDescription()
  {
    return _description;
  }

  /**
   * Get whether this feature is optional. An optional feature is one which the
   * user can choose to switch off.
   * 
   * @return true if this feature is optional.
   */
  public boolean isOptional()
  {
    return _isOptional;
  }
  
  /**
   * Gets the id of another extension which this feature forms a part of.
   * 
   * @return the id of another extension which this feature belongs to. May 
   *    return null if this feature is a standalone feature.
   */
  public String getPartOf()
  {
    return _partOf;
  }
}
