/* $Header: jdev/src/javaxide/src/javax/ide/extension/spi/LocationAdapter.java /main/1 2011/06/09 13:42:57 svassile Exp $ */

/* Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    svassile    06/02/11 - Creation
 */

/**
 *  @version $Header: LocatorWrapperFactory.java 02-jun-2011.13:55:56 svassile Exp $
 *  @author  svassile
 *  @since   12.1.1.0.0
 */

package javax.ide.extension.spi;

import javax.xml.stream.Location;

import org.xml.sax.Locator;

/**
 * <p>
 * An adapter interface for storing location information during XML parsing. 
 * </p>
 * 
 * <p>
 * Prior to 12.1.1.0.0, IDE extensions were parsed with SAX. SAX came with its own implementation of the notion of 
 * a Locator with the class, org.xml.sax.Locator. JDK's pull parsing APIs come with their own class for storing the same thing, 
 * javax.xml.stream.Location. To write code independent of the method of parsing, clients should use this interface 
 * instead.
 * </p>
 * 
 */
public interface LocationAdapter
  extends Location, Locator
{
  int getLineNumber();
  int getColumnNumber();
  int getCharacterOffset();
  String getPublicId();
  String getSystemId();
  LocationAdapter copyMe();
}
