/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu;

import javax.ide.Service;
import javax.ide.view.View;
import javax.ide.spi.ProviderNotFoundException;

/**
 * The menu manager is responsible for installing menu bars and toolbars into
 * Views.
 */
public abstract class MenuManager extends Service
{
  /**
   * Install a toolbar into the specified view.
   * 
   * @param toolbarId the id of a toolbar defined in the extension manifest.
   * @param view a view to install the toolbar into.
   */
  public abstract void installToolbar( String toolbarId, View view );

  /**
   * Install a menu bar into the specified view.
   * 
   * @param menubarId the id of a menu bar defined in the extension manifest.
   * @param view the view to install the menu bar into. Only top level views
   *    support the installation of menu bars.
   */
  public abstract void installMenubar( String menubarId, View view );
  
  protected void initialize()
  {
    // NO-OP
  }
  
  /**
   * Get the menu manager.
   * 
   * @return the menu manager.
   */
  public final static MenuManager getMenuManager()
  {
    try
    {
      return (MenuManager) getService( MenuManager.class  );
    }
    catch ( ProviderNotFoundException nse )
    {
      nse.printStackTrace();
      throw new IllegalStateException( "No menu manager" );
    }    
  }
}
