/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import java.util.List;
import javax.ide.Identifiable;

/**
 * A menu bar is an identified collection of Menus.
 */
public final class MenuBar implements Identifiable
{
  private final String _id;
  private final PositionMap _menus = new PositionMap();

  public MenuBar( String id )
  {
    _id = id;
  }
  
  public String getID()
  {
    return _id;
  }
  
  void addMenu( Menu menu )
  {
    _menus.add( menu );
  }
  
  public Menu getMenu( String id )
  {
    return (Menu) _menus.get( id );
  }

  public List getMenus()
  {
    return _menus.getSortedItems();
  }
 
}
