/*
 * @(#)TreeLocator.java
 */

package javax.ide.model.java.source;

import javax.ide.model.java.declaration.Declaration;
import javax.ide.model.java.source.tree.Tree;

/**
 * The TreeLocator interface provides a facility for the caller to map
 * a Declaration object to its declaring Tree object, if any. <p/>
 *
 * @author Andy Yu
 */
public interface TreeLocator
{
  // ----------------------------------------------------------------------

  /**
   * Gets the Tree object that declares the given declaration, null if
   * none.
   *
   * @return Gets the Tree object that declares the given declaration,
   * null if no matching Tree of the right kind is found.
   */
  public Tree getTree(Declaration d);
}
