/*
 * @(#)DereferenceExpressionT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for expressions performing dereference operations.
 * The three dereference expressions are: array access, method call,
 * and dot dereference. <p/>
 *
 * @author Andy Yu
 * */
public interface DereferenceExpressionT
  extends OperatorExpressionT
{
  // ----------------------------------------------------------------------

  /**
   * @return The lhs operand of this dereference. Null if none.
   *
   * If this is a dot dereference... well, you can figure that one out.
   *
   * If this is an array access, the lhs operand will be the array variable.
   *
   * If this is a method call, the lhs operand is optional.
   *
   * If this is a class creator, the lhs operand is optional. If there
   * is a lhs operand, it means that this is a qualified class creator and
   * the lhs operand is the outer class instance being used.
   */
  public ExpressionT getLhsOperand();

  /**
   * Attempts to set the lhs operand for this expression.
   *
   * @param e If null, then this will remove the lhs operand (legal
   * only for method calls).
   *
   * @throws UnsupportedOperationException if this operation is illegal.
   */
  public void setLhsOperand( ExpressionT e );
}
