/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */

package javax.ide.net;

import java.net.URI;

/**
 *  An instance of <CODE>URIExistsTest</CODE> registered with the
 *  {@link VirtualFileSystem} provides a way for the IDE to detect
 *  whether a particular URI is already in use.
 */
public interface URIExistsTest
{
  /**
   *  Returns <CODE>false</CODE> if the specified {@link URI} is
   *  unique.  An {@link URI} is unique if it points to a resource
   *  that does not currently exist, either at the actual location
   *  or within any in-memory caches (at implementor's discretion).
   *  Returns <CODE>true</CODE> otherwise.
   */
  public boolean uriExists( URI uri );
}
