--------------------------------------------------------------------------------
-- createRepositoryRoles
--
-- Create the UT_REPO_USER and UT_REPO_ADMINISTRATOR roles used by the unit
-- test repository.
--------------------------------------------------------------------------------

DECLARE
    v_count INTEGER := 0;
BEGIN
    SELECT COUNT (1) INTO v_count FROM dba_roles WHERE role = 'UT_REPO_USER';
    IF v_count != 0
    THEN
        EXECUTE IMMEDIATE ('DROP ROLE UT_REPO_USER');
    END IF;
    SELECT COUNT (1) INTO v_count FROM dba_roles WHERE role = 'UT_REPO_ADMINISTRATOR';
    IF v_count != 0
    THEN
        EXECUTE IMMEDIATE ('DROP ROLE UT_REPO_ADMINISTRATOR');
    END IF;
 END;
 /

CREATE ROLE UT_REPO_USER;

GRANT SELECT ON DBA_ROLE_PRIVS TO UT_REPO_USER;
GRANT SELECT ON DBA_TAB_PRIVS TO UT_REPO_USER;
GRANT SELECT ON DBA_ROLES TO UT_REPO_USER;
GRANT EXECUTE ON DBMS_LOCK TO UT_REPO_USER;

CREATE ROLE UT_REPO_ADMINISTRATOR;

GRANT UT_REPO_USER TO UT_REPO_ADMINISTRATOR WITH ADMIN OPTION;
GRANT DROP PUBLIC SYNONYM TO UT_REPO_ADMINISTRATOR;
GRANT CREATE PUBLIC SYNONYM TO UT_REPO_ADMINISTRATOR;

GRANT SELECT ON DBA_ROLE_PRIVS TO UT_REPO_ADMINISTRATOR;
GRANT SELECT ON DBA_TAB_PRIVS TO UT_REPO_ADMINISTRATOR;
GRANT SELECT ON DBA_ROLES TO UT_REPO_ADMINISTRATOR;
GRANT EXECUTE ON DBMS_LOCK TO UT_REPO_ADMINISTRATOR;
