if (!window.localStorage.firstInstall) {
    window.localStorage.firstInstall = true;
    chrome.tabs.create({url: "http://www.taokezhushou.com?from=plugin", selected: true});
}
window.localStorage.hidePlugin = window.localStorage.hidePlugin || 'false';
window.localStorage.keyPlugin = window.localStorage.keyPlugin || 90;
window.localStorage.dwzServer = window.localStorage.dwzServer || 'baidu';
window.localStorage.applyReason = window.localStorage.applyReason || '【淘客助手】网站会员申请贵店推广计划，望通过，祝合作愉快！谢谢！';
window.localStorage.uuid = window.localStorage.uuid || randomString(32);

//如果设置隐藏的时间超过一周，则恢复为显示插件
var date = new Date();
if (date.getTime() - window.localStorage.hideTimestamp > 1000 * 86400 * 7) {
    window.localStorage.hidePlugin = 'false';
}

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    switch (request.type) {
        case 'init':
            var date = new Date();
            var time = date.getTime();
            var sign = Math.ceil(time / 600000); 
            var version = window.localStorage.pluginVersion ? window.localStorage.pluginVersion : '1.0.0.0';

            if(!window.localStorage.sign || window.localStorage.sign != sign){
                window.localStorage.sign = sign;
                version = $.ajax({
                    url: "http://w.dareng.com/version.php",
                    async: false
                }).responseText;
                window.localStorage.pluginVersion = version;
            }

            $.ajax({
                type: 'GET',
                url: 'http://pcdn.taokezhushou.com/plugin/content7.js?version=' + version,
                dataType: 'text',
                success: function(data) {
                    data = data.replace(/TkzsPlugin/g,randomString(6));
                    chrome.tabs.executeScript(null, {
                        code: data,
                        allFrames: false
                    });
                },
                error: function(error) {
                    console.log(error)
                }
            });
            return true;
        case 'get':
            $.ajax({
                type: 'GET',
                url: request.url,
                data: request.postdata || {},
                dataType: request.dataType || 'json',
                success: function(data) {
                    sendResponse({ status:true, result:data });
                },
                error: function(err) {
                    sendResponse({ status:false, result:err });
                }
            });
            return true;
        case 'post':
            $.ajax({
                type: 'POST',
                url: request.url,
                data: request.data || {},
                dataType: request.dataType || 'json',
                success: function(data) {
                    sendResponse({ status:true, result:data });
                },
                error: function(err) {
                    sendResponse({ status:false, result:err });
                }
            });
            return true;
        case 'setting':
            sendResponse({
                hidePlugin: window.localStorage.hidePlugin,
                keyPlugin: window.localStorage.keyPlugin,
                dwzServer: window.localStorage.dwzServer,
                applyReason: window.localStorage.applyReason,
                uuid: window.localStorage.uuid
            });
            return true;
        case 'getSetting':
            var key = request.key;
            sendResponse(window.localStorage[key]);
            return true;
        case 'setSetting':
            var key = request.key;
            var value = request.value;
            window.localStorage[key] = value;
            return true;
        case 'cookie':
            chrome.cookies.get({
                url: request.url,
                name: request.name
            }, function(cookies) {
                cookies != null ? sendResponse(cookies.value) : sendResponse();
            });
            return true;
        case 'allCookie':
            chrome.cookies.getAll({
                url: request.url
            }, function(cookies) {
                var i = 0,
                    len = cookies.length,
                    str = '';
                for (; i < len; i++) {
                    str += cookies[i].name + "=" + cookies[i].value + "; ";
                }
                sendResponse(str)
            });
            return true;
        case 'setCookie':
            chrome.cookies.set({
                url: request.url,
                name: request.name,
                value: request.value,
            }, function(cookie) {
                cookies != null ? sendResponse(cookie) : sendResponse();
            })
            return true;
        case 'removeCookie':
            chrome.cookies.remove({
                url: request.url,
                name: request.name
            }, function(cookies) {
                cookies != null ? sendResponse(true) : sendResponse();
            });
            return true;
        case 'getversion':
            var xhr = new XMLHttpRequest();
            xhr.open('GET', chrome.extension.getURL('manifest.json'), false);
            xhr.send(null);
            var manifest = JSON.parse(xhr.responseText);
            sendResponse(manifest.version);
            return true;
        case 'createTab':
            chrome.tabs.create({ "index": 0, "url": request.url, "selected": false }, function (tab) {
                chrome.tabs.onUpdated.addListener(function (tabId, changeInfo, tabs) {
                    if (tab.id == tabId && tabs.url.indexOf('s.click.taobao.com') == -1) {
                        chrome.tabs.remove(tab.id,function(){});
                        sendResponse(tabs.url);
                    }
                });
            });
            return true;
        case 'getTaobaoShopUrl':
            var filter = { urls: ["*://s.click.taobao.com/*"]},
                opt_extraInfoSpec = [ "requestHeaders", "blocking" ],
                xhr = new XMLHttpRequest(),
                xhrTu = new XMLHttpRequest(),
                tu = '',
                shopUrl = request.url;

            xhr.open('GET', shopUrl, true);
            xhr.onreadystatechange = function() {
                if(xhr.readyState === 3 ){
                    var tmp = xhr.responseURL.split("?")[xhr.responseURL.split("?").length-1].split('=');
                    tu = unescape(tmp[tmp.length -1 ]);

                    var callback = function(details) {
                        var gotRef = false;
                        for (var n in details.requestHeaders) {
                            gotRef = details.requestHeaders[n].name.toLowerCase() == "referer";
                            if (gotRef) {
                                details.requestHeaders[n].value = xhr.responseURL;
                                break;
                            }
                        }
                        if (!gotRef) {
                            details.requestHeaders.push({name: "Referer", value: xhr.responseURL});
                        }
                        return {requestHeaders: details.requestHeaders};
                    }
                    chrome.webRequest.onBeforeSendHeaders.addListener(callback, filter, opt_extraInfoSpec);
                    xhrTu.open('GET', tu, true);
                    xhrTu.onreadystatechange = function() {
                        if(xhrTu.readyState === 2 ){
                            chrome.webRequest.onBeforeSendHeaders.removeListener(callback);
                            sendResponse(xhrTu.responseURL);
                        }
                    }
                    xhrTu.send(null);
                }
            }
            xhr.send(null);
            return true;
        case 'getplus':
            $.ajax({
                type: 'GET',
                url: request.url,
                data: request.postdata || {},
                dataType: request.dataType || 'json',
                headers: {
                    Authorization: request.authorization || ''
                },
                success: function(data) {
                    sendResponse({ status:true, result:data });
                },
                error: function(err) {
                    sendResponse({ status:false, result:err });
                }
            });
            return true;
    }
});

function randomString(len) {
    len = len || 32;
    var $chars = 'QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm';
    var maxPos = $chars.length;
    var pwd = '';
    for (i = 0; i < len; i++) {
        pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return pwd;
}
