const { app } = require('electron')
const {WindowManager} = require('./window');

// Squirrel.Windows target is maintained, but deprecated.
// https://www.electron.build/configuration

app.whenReady().then(()=>{
    const manager = new WindowManager(app);
    manager.createMainWindow();
    app.on('activate', () => {
        manager.createMainWindowIfNeed();
    })
})

app.on('window-all-closed', () => {
    console.log('window-all-closed')
    if(process.platform !== 'darwin') {
        app.quit();
    }
})
