package debugOutputerGUI;

public class DebugOutputer implements qhs.interfaces.DebugOutputer {

    private DebugDialog dialog = null;

    public void initialize() {
        //以下代码拷贝自DebugDialog.java的main().

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                dialog = new DebugDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void output(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":" + string + "\n");
    }

    public void outputRequest(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":接收到的请求:" + string + "\n");
    }

    public void outputResponse(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":正在发送的答复:" + string + "\n");
    }

    public void outputRequestDynamicTableState(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":请求头域动态表:" + string + "\n");
    }

    public void outputResponseDynamicTableState(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":答复头域动态表:" + string + "\n");
    }

    public void outputReceivedFrame(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":接收到的帧:" + string + "\n");
    }

    public void outputSendingFrame(long threadID, String string) throws Throwable {
        this.dialog.appendText(threadID + ":正在发送的帧:" + string + "\n");
    }

    public void finish() {
        dialog.setVisible(false);
        dialog.dispose();
    }
}
