package errorResponseCreater;

import qhs.interfaces.ErrorReason;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.ResponseHeader;
import qhs.interfaces.Connection;
import qhs.sys.ResponseHeaderCreater;
import qhs.sys.StaticName;

public class ErrorResponseCreater implements qhs.interfaces.ErrorResponseCreater {

    private static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("utf-8");
        } catch (Exception exc) {
        }

        return null;
    }
    private static byte[] entityBodyPart1 = getUTF8Bytes("<html>"
            + "  <head>"
            + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"
            + "  </head>"
            + "  <body><h1>");
    private static byte[] entityBodyPart2 = getUTF8Bytes("</h1></body>"
            + "</html>");

    //--------------------------------------------------------------------------
    public void invoke(ThreadContext tc, Connection conn, ErrorReason er) throws Throwable {

        ResponseHeader cache_control = ResponseHeaderCreater.create(StaticName.cache_control, "no-store, no-cache");
        ResponseHeader content_type = ResponseHeaderCreater.create(StaticName.content_type, "text/html; charset=utf-8");

        final qhs.interfaces.HTTPResponse resp = tc.getResponse();

        resp.addHeader(cache_control);
        resp.addHeader(content_type);
        resp.tryToSendPartOfPayloadBody(entityBodyPart1);

        java.util.Calendar cal = java.util.Calendar.getInstance();
        resp.tryToSendPartOfPayloadBody(getUTF8Bytes("<pre>"
                + "演示错误答复创建器，错误原因：\r\n"
                + "\r\n"
                + er.get() + "\r\n"
                + "\r\n"
                + "\t\t\t\t"
                + cal.get(java.util.Calendar.YEAR) + "/"
                + (cal.get(java.util.Calendar.MONTH) + 1) + "/"
                + cal.get(java.util.Calendar.DAY_OF_MONTH) + " "
                + cal.get(java.util.Calendar.HOUR_OF_DAY) + ":"
                + cal.get(java.util.Calendar.MINUTE) + ":"
                + cal.get(java.util.Calendar.SECOND) + ""
                + "</pre>"));
        resp.tryToSendPartOfPayloadBody(entityBodyPart2);

    }

    public String update(String string) throws Throwable {
        return null;
    }
}
