package fileretriever;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TempFile implements qhs.interfaces.File {

    private final byte[] content;
    private final long lastModified;
    private int position = 0;

    public TempFile(byte[] content, long lastModified) {
        this.content = content;
        this.lastModified = lastModified;
    }

    public long size() {
        return this.content.length;
    }

    public long lastModified() {
        return this.lastModified;
    }

    //--------------------------------------------------------------------------
    public int read(ByteBuffer buffer) {
        int res = buffer.remaining();
        if (res > content.length - position) {
            res = content.length - position;
        }

        buffer.put(content, position, res);
        position += res;
        return res;
    }
    //--------------------------------------------------------------------------
    private boolean vIsClosed = false;

    public void close() {
        vIsClosed = true;
    }

    //--------------------------------------------------------------------------
    public boolean isClosed() {
        return vIsClosed;
    }

    public void reset() {
        position = 0;
    }
}
