package httpServiceModule;

import java.util.Calendar;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.Connection;
import qhs.sys.ResponseHeaderCreater;
import qhs.sys.StaticName;

public class ServerTime1 implements qhs.interfaces.HTTPServiceModule {

    public ServerTime1() {
    }

    public String getID() {
        return "server-time-1";
    }

    //--------------------------------------------------------------------------
    public void invoke(ThreadContext tc, Connection conn) throws Throwable {
        final qhs.interfaces.HTTPResponse response = tc.getResponse();
        final String charset = "utf-8";

        response.addHeader(ResponseHeaderCreater.create(StaticName.content_type, "text/html; charset=" + charset));
        response.addHeader(ResponseHeaderCreater.create(StaticName.cache_control, "no-store, no-cache"));

        response.tryToSendPartOfPayloadBody(("<html>"
                + "  <head>"
                + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"
                + "  </head>"
                + "  <body>"
                + "    <p><h1>").getBytes(charset));

        Calendar cal = Calendar.getInstance();

        final String timeStr = "服务器时间："
                + cal.get(Calendar.YEAR) + "/" + (cal.get(Calendar.MONTH) + 1) + "/" + cal.get(Calendar.DAY_OF_MONTH) + " "
                + cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);

        response.tryToSendPartOfPayloadBody(timeStr.getBytes(charset));
        response.tryToSendPartOfPayloadBody(("</h1></p>"
                + "  <p><samp>单击浏览器的\"刷新\"按钮更新页面的服务器时间。</samp></p>"
                + "  </body>"
                + "</html>").getBytes(charset));

    }

    //--------------------------------------------------------------------------
    public void push(ThreadContext tc, Connection conn) throws Throwable {
    }

    //--------------------------------------------------------------------------
    public String update(String string) throws Throwable {
        return null;
    }

    public void clear() throws Throwable {
    }
}
