package mFormData;

import qhs.interfaces.ThreadContext;
import qhs.interfaces.Connection;

public class HTTPServiceModule_1 implements qhs.interfaces.HTTPServiceModule {

    public static final String mediaType = "multipart/form-data";
    //--------------------------------------------------------------------------

    private static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("utf-8");
        } catch (Exception exc) {
        }

        return null;
    }

    //--------------------------------------------------------------------------
    public String getID() {
        return "get-form-page-m";
    }

    public void invoke(ThreadContext tc, Connection conn) throws Throwable {
        tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                + "<html>\r\n"
                + "   <head>\r\n"
                + "      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
                + "   </head>\r\n"
                + "   <body>\r\n"
                + "      <form method=\"post\"\r\n"
                + "         enctype=\"" + mediaType + "\"\r\n"
                + "         action=\"" + HTTPServiceModule_2.serviceModuleID + ".id\">\r\n"));

        final int uploadedFileCount = 3;

        for (int i = 0; i < uploadedFileCount; i++) {
            tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                    + "         <p>"
                    + "            <label>书名:</label>\r\n"
                    + "            <input type=\"text\" name=\"book-title" + (i + 1) + "\" value=\"\" size=\"30\" maxlength=\"28\">\r\n"
                    + ""
                    + "            <label>种类:</label>\r\n"
                    + "            <select name=\"book-type" + (i + 1) + "\">\r\n"
                    + "               <option selected=\"true\" >编程语言</option>\r\n"      
                    + "               <option>Web技术</option>\r\n"
                    + "               <option>大数据</option>\r\n"
                    + "            </select>\r\n"
                    + ""
                    + "            <label>书籍文件:</label>\r\n"
                    + "            <input type=\"file\" name=\"book-content" + (i + 1) + "\" size=\"25\" maxlength=\"25\">\r\n"
                    + "         </p>"));
        }

        tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                + "         <input type=\"submit\" value=\"上传\">\r\n"
                + ""
                + "      </form>\r\n"
                + "   </body>\r\n"
                + "</html>\r\n"));
    }

    public void push(ThreadContext tc, Connection conn) throws Throwable {
    }

    public String update(String str) {
        return null;
    }

    public void clear() {
    }
}
