package mFormData;

import java.nio.file.*;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.MFormDataParser;
import qhs.interfaces.MFormDataListener;
import qhs.interfaces.headerParser.HeaderParser;
import qhs.impl.headerParser.Content_DispositionParserImpl;
import qhs.interfaces.Connection;

public class HTTPServiceModule_2 implements qhs.interfaces.HTTPServiceModule {

    public static final String serviceModuleID = "list-names-and-values-m";

    private static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("utf-8");
        } catch (Exception exc) {
        }

        return null;
    }

    public String getID() {
        return serviceModuleID;
    }

    private static class ControlContext {

        private final String controlName;
        private byte[] controlValue = null;
        private int controlValueLength = 0;
        private String fileName = null;
        private String md5 = null;
        private String filePath = null;

        public ControlContext(String name) {
            this.controlName = name;
        }
    }

    private static class FormDataListener implements MFormDataListener {

        private final java.util.ArrayList<ControlContext> controlList = new java.util.ArrayList();
        private final String nameStr = "Content-Disposition";//在Chrome74发送的multipart/form-data类型表单数据内部，头域的名称仍然包含大写字母。
        private final byte[] headerNameBuffer = new byte[100];
        private final byte[] headerValueBuffer = new byte[200];
        private final Content_DispositionParserImpl headerParser = new Content_DispositionParserImpl();
        private int operation = 0;
        private byte[] bodyArea = null;
        private int bodyAreaLength = 0;
        private int fileCount = 0;
        private FileOutputStream out = null;
        private MessageDigest md5 = null;
        //----------------------------------------------------------------------

        private FormDataListener() {
            try {
                md5 = MessageDigest.getInstance("md5");
            } catch (Exception exc) {
            }
        }

        public boolean parsedHeaders(MFormDataParser.Header[] headers, int count) {
            operation = 0;
            md5.reset();

            for (int i = 0; i < count; i++) {
                final int headerNameLength = headers[i].getName(headerNameBuffer, 0);

                //查找、分析Content-Disposition。
                if (headerNameLength == nameStr.length()) {
                    if (nameStr.equalsIgnoreCase(new String(headerNameBuffer, 0, headerNameLength))) {
                        final int headerValueLength = headers[i].getValueLength();

                        if (0 < headerValueLength && headerValueLength <= headerValueBuffer.length) {
                            headers[i].getValue(headerValueBuffer, 0);

                            if (headerParser.parse(headerValueBuffer, 0, headerValueLength) == HeaderParser.ParsingResults.OK) {
                                final byte[] ba = headerParser.getNameParameterValue();
                                if (ba != null && 0 < ba.length) {
                                    try {
                                        final String name = new String(ba, "utf-8");
                                        ControlContext o = new ControlContext(name);
                                        controlList.add(o);

                                        if (name.startsWith("book-title")) {
                                            operation = 1;//读取书名

                                        } else if (name.startsWith("book-type")) {
                                            operation = 2;//读取书的所属类型。

                                        } else if (name.startsWith("book-content")) {
                                            operation = 3;//读取书的内容。

                                            if (0 < headerParser.getFilenameParameterValueLength()) {
                                                o.fileName = new String(headerParser.getFilenameParameterValue());
                                            }

                                            o.filePath = System.getProperty("user.home") + java.io.File.separatorChar + "uploaded-file-" + (++fileCount) + ".txt";
                                            Files.deleteIfExists(Paths.get(o.filePath));
                                            out = new FileOutputStream(o.filePath);
                                        }

                                    } catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
            }

            return true;
        }

        public boolean readingBodyArea(final byte[] buffer, final int length) {
            try {

                if (operation == 1 || operation == 2) {
                    if (bodyArea == null) {
                        bodyArea = new byte[length];
                        System.arraycopy(buffer, 0, bodyArea, 0, length);
                    } else {
                        byte[] ba = new byte[bodyArea.length + length];
                        System.arraycopy(bodyArea, 0, ba, 0, bodyArea.length);
                        System.arraycopy(buffer, 0, ba, bodyArea.length, length);
                        bodyArea = ba;
                    }

                } else if (operation == 3) {
                    out.write(buffer, 0, length);
                    md5.update(buffer, 0, length);
                }

            } catch (Exception exc) {
                exc.printStackTrace();
            } finally {
                bodyAreaLength += length;
            }

            return true;
        }

        public boolean readBodyArea() {
            try {
                ControlContext o = controlList.get(controlList.size() - 1);

                if (operation == 1 || operation == 2) {
                    o.controlValue = bodyArea;
                    o.controlValueLength = bodyAreaLength;

                } else if (operation == 3) {
                    byte[] digest = md5.digest();
                    String s = new String();

                    for (final byte b : digest) {
                        final int num = b & 0xff;
                        s += ((0 == (num >>> 4)) ? "0" : "") + Integer.toHexString(num);
                    }

                    o.md5 = s;
                    o.controlValueLength = bodyAreaLength;

                    out.close();
                    out = null;
                }
            } catch (Exception exc) {
            } finally {
                bodyArea = null;
                bodyAreaLength = 0;
            }

            return true;
        }

        public void clear() {
            controlList.clear();
            fileCount = 0;
        }
    }

    public void invoke(ThreadContext tc, Connection conn) throws Throwable {

        boolean parsingFormData = false;
        FormDataListener listener = null;

        if (tc.getRequest().isPOST() && tc.getRequest().getPayloadBodyLength() > 0) {
            listener = new FormDataListener();

            try {
                tc.getRequest().parsePayloadBody(listener, tc.getTempByteBuffer());//本语句分析表单数据。
                parsingFormData = true;
            } catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        try {
            if (parsingFormData) {
                //System.out.println(new String(tc.getRequest().getPayloadBody()));
                
                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<html>\r\n"
                        + "  <head>\r\n"
                        + "     <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
                        + "  </head>\r\n"
                        + "  <body>\r\n"
                        + "     <p>分析属于" + HTTPServiceModule_1.mediaType + "媒体类型的表单数据。</p>\r\n"
                        + "     <p>浏览器使用" + new String(tc.getRequest().isGET() ? "GET" : "POST") + "请求方法对qhs发出http请求。</p>\r\n"
                        + "     <p>表单数据成为http请求内部的payload-body部件。</p>"
                        + "     <table border=\"1\" frame=\"border\">\r\n"));

                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<tr>\r\n"
                        + "<td>控件名称</td>\r\n"
                        + "<td>控件值</td>\r\n"
                        + "<td>控件值的长度</td>\r\n"
                        + "<td>上传的文件</td>\r\n"
                        + "<td>md5值</td>\r\n"
                        + "<td>存放控件值的文件</td>\r\n"
                        + "</tr>\r\n"));

                for (int i = 0; i < listener.controlList.size(); i++) {
                    ControlContext o = listener.controlList.get(i);

                    String s = ""
                            + "<tr>\r\n"
                            + "<td>\r\n" + o.controlName + "</td>\r\n"
                            + "<td>\r\n" + (o.controlValue != null ? new String(o.controlValue, "utf-8") : "") + "</td>\r\n"
                            + "<td>\r\n" + o.controlValueLength + "个字节" + "</td>\r\n"
                            + "<td>\r\n" + (o.fileName != null ? o.fileName : "") + "</td>\r\n"
                            + "<td>\r\n" + (o.md5 != null ? o.md5 : "") + "</td>\r\n"
                            + "<td>\r\n" + (o.filePath != null ? o.filePath : "") + "</td>\r\n";

                    tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(s));

                }
                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "     </table>\r\n"
                        + "  </body>\r\n"
                        + "</html>\r\n"));
            } else {
                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<html>\r\n"
                        + "  <head>\r\n"
                        + "     <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
                        + "  </head>\r\n"
                        + "  <body>\r\n"
                        + "     <p>http请求无效。</p>\r\n"
                        + "  </body>\r\n"
                        + "</html>\r\n"));
            }
        } finally {
            if (listener != null) {
                listener.clear();
            }
        }
    }

    public void push(ThreadContext tc, Connection conn) throws Throwable {
    }

    public String update(String str) {
        return null;
    }

    public void clear() {
    }
}
