package httpServiceModule;

public class ServerPush implements qhs.interfaces.HTTPServiceModule {

    public String getID() {
        return "server-push";
    }
    //--------------------------------------------------------------------------

    private static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("utf-8");
        } catch (Exception exc) {
        }

        return null;
    }
    //--------------------------------------------------------------------------
    private final qhs.interfaces.ResponseHeader header_cache_control;
    private final qhs.interfaces.ResponseHeader header_content_type;

    public ServerPush() {
        qhs.interfaces.ResponseHeader temp_cache_control = null;
        qhs.interfaces.ResponseHeader temp_content_type = null;

        try {
            temp_cache_control = qhs.sys.ResponseHeaderCreater.create(qhs.sys.StaticName.cache_control, "no-store, no-cache");
            temp_content_type = qhs.sys.ResponseHeaderCreater.create(qhs.sys.StaticName.content_type, "text/html; charset=utf-8");
        } catch (Throwable exc) {
        }

        header_cache_control = temp_cache_control;
        header_content_type = temp_content_type;
    }

    public void invoke(qhs.interfaces.ThreadContext tc, qhs.interfaces.Connection conn) throws Throwable {
        final qhs.interfaces.HTTPResponse response = tc.getResponse();
        final int maxRow = 5;
        final int maxCol = 9;
        String[] urls = new String[maxRow * maxCol + 1];
        int index = 0;
        //----------------------------------------------------------------------
        //生成多个url。
        for (int row = 1; row <= maxRow; row++) {
            for (int col = 1; col <= maxCol; col++) {
                urls[index++] = "/pics/" + row + "" + col + ".png";
            }
        }

        urls[index] = "/server-time-2.id";
        //----------------------------------------------------------------------
        //推送多个url。
        for (String url : urls) {
            tc.push(url.getBytes());
        }
        //----------------------------------------------------------------------
        //构建、发送http答复。

        //对http答复添加多个link头域，每一个link头域引用一个推送url。
        for (int i = 0; i < urls.length - 1; i++) {
            response.addHeader(qhs.sys.ResponseHeaderCreater.create(qhs.sys.StaticName.link,
                    "<" + urls[i] + ">; rel=preload; as=image"));
        }
        response.addHeader(qhs.sys.ResponseHeaderCreater.create(qhs.sys.StaticName.link,
                "<" + urls[urls.length - 1] + ">"));

        response.addHeader(header_content_type);
        response.addHeader(header_cache_control);

        response.tryToSendPartOfPayloadBody(getUTF8Bytes(""
                + "<html>\n"
                + "  <head>\n"
                + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n"
                + "  </head>\n"
                + "  <body>\n"
                + "     <table border=\"0\" frame=\"void\" cellspacing=\"1\" cellpadding=\"0\" >\n"));

        index = 0;
        for (int row = 1; row <= maxRow; row++) {
            response.tryToSendPartOfPayloadBody(getUTF8Bytes("        <tr>\n"));

            for (int col = 1; col <= maxCol; col++) {

                response.tryToSendPartOfPayloadBody(getUTF8Bytes("          <td><img "
                        + "src=\"" + urls[index++]/*在html内容引用被推送的URL。*/ + "\" /></td>\n"));
            }

            response.tryToSendPartOfPayloadBody(getUTF8Bytes("        </tr>\n"));
        }

        response.tryToSendPartOfPayloadBody(getUTF8Bytes("        "
                + "<tr>"
                + "<td colspan=\"4\"><iframe width=\"600\" height=\"80\" "
                + "src=\"" + urls[index]/*在html内容引用被推送的URL。*/ + "\" /></td>"
                + "</tr>\n"));

        response.tryToSendPartOfPayloadBody(getUTF8Bytes(""
                + "     </table>\n"));
        response.tryToSendPartOfPayloadBody(getUTF8Bytes(""
                + "  </body>\n"
                + "</html>\n"));
    }

    public void push(qhs.interfaces.ThreadContext tc, qhs.interfaces.Connection conn) throws Throwable {
    }

    public String update(String str) {
        return null;
    }

    public void clear() {
    }
}
