package httpServiceModule;

import java.util.Calendar;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.Connection;
import qhs.sys.ResponseHeaderCreater;
import qhs.sys.StaticName;

public class ServerTime2 implements qhs.interfaces.HTTPServiceModule {

    public ServerTime2() {
    }

    public String getID() {
        return "server-time-2";
    }

    //--------------------------------------------------------------------------
    public void invoke(ThreadContext tc, Connection conn) throws Throwable {

    }

    //--------------------------------------------------------------------------
    public void push(ThreadContext tc, Connection conn) throws Throwable {
        final qhs.interfaces.HTTPResponse response = tc.getPushedResponse();
        final String charset = "utf-8";

        response.addHeader(ResponseHeaderCreater.create(StaticName.content_type, "text/html; charset=" + charset));
        response.addHeader(ResponseHeaderCreater.create(StaticName.cache_control, "no-store, no-cache"));

        response.tryToSendPartOfPayloadBody(("<html>"
                + "  <head>"
                + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">"
                + "  </head>"
                + "  <body>"
                + "    <p><h1>").getBytes(charset));

        Calendar cal = Calendar.getInstance();

        final String timeStr = "页面刷新时间："
                + cal.get(Calendar.YEAR) + "/" + (cal.get(Calendar.MONTH) + 1) + "/" + cal.get(Calendar.DAY_OF_MONTH) + " "
                + cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);

        response.tryToSendPartOfPayloadBody(timeStr.getBytes(charset));
        response.tryToSendPartOfPayloadBody(("</h1></p>"
                + "  </body>"
                + "</html>").getBytes(charset));

    }

    //--------------------------------------------------------------------------
    public String update(String string) throws Throwable {
        return null;
    }

    public void clear() throws Throwable {
    }
}
