package socketChannelRW;

import javax.crypto.*;
import javax.crypto.spec.*;
import java.nio.ByteBuffer;
import java.util.Random;
import java.nio.channels.SocketChannel;
import qhs.interfaces.Connection;
import qhs.interfaces.ReadableDataDetecter;

public class AESCipher {

    private final int tLen = 128;
    private final String password = "1234567890abcdef";
    private final Cipher cipher;
    private final Random rand = new Random();
    private final byte[] iv = new byte[password.length()];
    private final byte[] add = new byte[password.length()];
    private final SecretKeySpec sks;

    public AESCipher() {
        Cipher tempCipher = null;
        SecretKeySpec tempSks = null;

        try {
            tempCipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            tempSks = new SecretKeySpec(password.getBytes(), "AES");
        } catch (Throwable exc) {
        }

        cipher = tempCipher;
        sks = tempSks;
    }

    public byte[] decrypt(byte[] cipherText) {

        try {
            GCMParameterSpec gcmp = new GCMParameterSpec(tLen, cipherText, 0, iv.length);
            cipher.init(Cipher.DECRYPT_MODE, sks, gcmp);
            cipher.updateAAD(cipherText, iv.length, add.length);
            return cipher.doFinal(cipherText, iv.length + add.length, cipherText.length - iv.length - add.length);
        } catch (Exception exc) {
        }

        return null;
    }

    public byte[] encrypt(byte[] plainText) {
        try {
            rand.nextBytes(iv);
            GCMParameterSpec gcmp = new GCMParameterSpec(tLen, iv);
            cipher.init(Cipher.ENCRYPT_MODE, sks, gcmp);

            rand.nextBytes(add);
            cipher.updateAAD(add);

            byte[] ba = cipher.doFinal(plainText);
            byte[] res = new byte[iv.length + add.length + ba.length];

            System.arraycopy(iv, 0, res, 0, iv.length);
            System.arraycopy(add, 0, res, iv.length, add.length);
            System.arraycopy(ba, 0, res, iv.length + add.length, ba.length);

            return res;
        } catch (Exception exc) {
        }

        return null;
    }

//    //--------------------------------------------------------------------------
//    private static String getRandString(int length) {
//        char[] ca = new char[length];
//        Random r = new Random();
//
//        for (int i = 0; i < ca.length; i++) {
//            int j = r.nextInt(26 + 26 + 10);
//
//            if (j < 26) {
//                ca[i] = (char) ('A' + j);
//            } else if (j < 26 + 26) {
//                ca[i] = (char) ('a' + j - 26);
//            } else {
//                ca[i] = (char) ('0' + j - 26 - 26);
//            }
//        }
//
//        return new String(ca);
//    }
//
//    public static void main(String[] args) {
//        int count = 0;
//        try {
//            AESCipher o = new AESCipher();
//
//            for (int plainTextLength = 0; plainTextLength < 2000; plainTextLength++) {
//                final String plainText1 = getRandString(plainTextLength);
//
//                byte[] cipherText = o.encrypt(plainText1.getBytes());
//                final String plainText2 = new String(o.decrypt(cipherText));
//
//                if (!plainText2.equals(plainText1)) {
//                    System.out.println("ERROR:decrypt().");
//                }
//
//                count++;
//            }
//
//            System.out.println("已测试了" + count + "个数据。");
//            System.out.println("Encrypt()、decrypt() pass.");
//        } catch (Throwable exc) {
//            exc.printStackTrace();
//        }
//    }
}
