package socketChannelRW;

import javax.crypto.*;
import javax.crypto.spec.*;
import java.nio.ByteBuffer;
import java.util.Random;
import java.nio.channels.SocketChannel;
import qhs.interfaces.Connection;
import qhs.interfaces.ReadableDataDetecter;

public class SocketChannelRW_cipher implements qhs.interfaces.SocketChannelRW {

    private final AESCipher cipher = new AESCipher();

    public int read(Connection conn, ReadableDataDetecter rdd,
            ByteBuffer buffer, SocketChannel sc) throws Throwable {

        buffer.clear();
        buffer.limit(2);

        while (buffer.hasRemaining()) {
            if (sc.read(buffer) <= 0) {
                return -1;
            }
        }

        final int cipherTextLength = ((buffer.get(0) & 0xff) << 8) | (buffer.get(1) & 0xff);
        buffer.limit(2 + cipherTextLength);

        while (buffer.hasRemaining()) {
            if (sc.read(buffer) <= 0) {
                return -1;
            }
        }

        byte[] readBytes = new byte[buffer.position()];
        buffer.flip();
        buffer.get(readBytes);

        byte[] cipherText = new byte[cipherTextLength];
        System.arraycopy(readBytes, 2, cipherText, 0, cipherText.length);

        byte[] plainText = cipher.decrypt(cipherText);//调用AESCipher.decrypt()解密HTTP/2数据。
        buffer.clear();
        buffer.put(plainText);

        return plainText.length;
    }

    public int write(Connection conn, ReadableDataDetecter rdd,
            ByteBuffer buffer, SocketChannel sc) throws Throwable {
        final int remaining = buffer.remaining();
        byte[] plainText = new byte[remaining];
        buffer.get(plainText);

        byte[] cipherText = cipher.encrypt(plainText);//调用AESCipher.encrypt()加密HTTP/2数据。

        final int payloadLength = cipherText.length;
        final byte[] encodedLength = new byte[]{(byte) ((payloadLength >>> 8) & 0xff), (byte) (payloadLength & 0xff)};

        byte[] sendingBytes = new byte[encodedLength.length + payloadLength];
        sendingBytes[0] = encodedLength[0];
        sendingBytes[1] = encodedLength[1];

        System.arraycopy(cipherText, 0, sendingBytes, encodedLength.length, cipherText.length);

        ByteBuffer buffer2 = ByteBuffer.wrap(sendingBytes);

        if (sc.write(buffer2) != sendingBytes.length) {
            return -1;
        }

        return remaining;
    }

}
