package uFormData;

import qhs.interfaces.Connection;
import qhs.interfaces.ThreadContext;

public class HTTPServiceModule_2 implements qhs.interfaces.HTTPServiceModule {

    public static final String serviceModuleID = "list-names-and-values-u";

    private static byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("utf-8");
        } catch (Exception exc) {
        }

        return null;
    }

    public String getID() {
        return serviceModuleID;
    }

    private static class FormDataListener implements qhs.interfaces.UFormDataListener {

        private final char[] tempCharBuffer;
        private final java.util.ArrayList<String> nameList = new java.util.ArrayList<>();
        private final java.util.ArrayList<String> valueList = new java.util.ArrayList<>();

        public FormDataListener(char[] ca) {
            this.tempCharBuffer = ca;
        }

        public char[] getTempCharBuffer() {
            return this.tempCharBuffer;
        }

        public boolean parsedName(char[] buffer, int length) {
            nameList.add(new String(buffer, 0, length));
            valueList.add(new String());
            return true;
        }

        public boolean parsedValue(char[] buffer, int length) {
            valueList.set(nameList.size() - 1, new String(buffer, 0, length));
            return true;
        }

        public void clear() {
            nameList.clear();
            valueList.clear();
        }
    }

    public void invoke(ThreadContext tc, Connection conn) throws Throwable {

        boolean parsingFormData = false;
        FormDataListener listener = null;

        if (tc.getRequest().isGET() && tc.getRequest().getRequestURI().getQueryLength(true) > 0) {
            listener = new FormDataListener(tc.getTempCharBuffer());

            try {
                tc.getRequest().getRequestURI().parseQuery(listener, tc.getTempCharBuffer());//本语句分析表单数据。
                parsingFormData = true;
            } catch (Exception exc) {
            }

        } else if (tc.getRequest().isPOST() && tc.getRequest().getPayloadBodyLength() > 0) {
            listener = new FormDataListener(tc.getTempCharBuffer());

            try {
                tc.getRequest().parsePayloadBody(listener, tc.getTempByteBuffer(), tc.getTempCharBuffer());//本语句分析表单数据。
                parsingFormData = true;
            } catch (Exception exc) {
            }
        }

        try {
            if (parsingFormData) {
                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<html>\r\n"
                        + "  <head>\r\n"
                        + "     <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
                        + "  </head>\r\n"
                        + "  <body>\r\n"
                        + "     <p>分析属于" + HTTPServiceModule_1.mediaType + "媒体类型的表单数据。</p>\r\n"
                        + "     <p>表单数据成为" + (tc.getRequest().isGET() ? "URL的query部件" : "http请求内部的payload-body部件") + "。</p>\r\n"
                        + "     <table border=\"1\" frame=\"border\" width=\"300\" >\r\n"));

                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<tr>\r\n"
                        + "<td>控件名称</td>\r\n"
                        + "<td>控件值</td>\r\n"
                        + "</tr>\r\n"));

                for (int i = 0; i < listener.nameList.size(); i++) {
                    tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                            + "<tr>\r\n"
                            + "<td>\r\n" + listener.nameList.get(i) + "</td>\r\n"
                            + "<td>\r\n" + listener.valueList.get(i) + "</td>\r\n"
                            + "</tr>\r\n"));
                }

                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "     </table>\r\n"
                        + "  </body>\r\n"
                        + "</html>\r\n"));
            } else {
                tc.getResponse().tryToSendPartOfPayloadBody(getUTF8Bytes(""
                        + "<html>\r\n"
                        + "  <head>\r\n"
                        + "     <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\r\n"
                        + "  </head>\r\n"
                        + "  <body>\r\n"
                        + "     <p>http请求未包含有表单数据或者表单数据有错误。</p>\r\n"
                        + "  </body>\r\n"
                        + "</html>\r\n"));
            }

        } finally {
            if (listener != null) {
                listener.clear();
            }
        }
    }

    public void push(ThreadContext tc, Connection conn) throws Throwable {
    }

    public String update(String str) {
        return null;
    }

    public void clear() {
    }
}
