package urlRewriter;

import qhs.interfaces.ThreadContext;
import qhs.interfaces.URIParser;
import qhs.interfaces.Connection;
import qhs.interfaces.ResponseHeader;
import qhs.sys.RewriteResult;

public class URLRewriter implements qhs.interfaces.URLRewriter {

    public RewriteResult rewrite(ThreadContext tc, Connection conn, URIParser uriParser) throws Throwable {
        if (tc.isPushing()) {
            //tc.isPushing()的返回值等于true，表示存放在uriParser的URL是推送URL。
            return RewriteResult.RESOURCE_URL;
        } else {
            //tc.isPushing()的返回值等于false，表示存放在uriParser的URL是请求URI(Request-URI)。

            final String query = new String(uriParser.getQuery(false));
            if (query.equals("tr")) {
                //如果query部件等于"tr"，就把存放在uriParser的URL用于构建表达临时重定向的http答复。
                uriParser.clearQuery();
                return RewriteResult.TEMPERARY_REDIRECTED_URL;
            } else if (query.equals("pr")) {
                //如果query部件等于"pr"，就把存放在uriParser的URL用于构建表达永久重定向的http答复。
                uriParser.clearQuery();
                return RewriteResult.PERMANENT_REDIRECTED_URL;
            }
        }

        return RewriteResult.RESOURCE_URL;
    }

    public ResponseHeader[] getAppendedResponseHeaders() {
        return null;
    }

    public String update(String str) throws Throwable {
        return null;
    }
}
