package wsServiceModule;

import java.util.Calendar;
import qhs.interfaces.Connection;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.WebSocketStream;

public class WSServiceModule implements qhs.interfaces.WSServiceModule {

    private static class TempWebSocketListener implements qhs.interfaces.WebSocketListener {

        private String frameType = null;
        private boolean isStreamClosed = false;
        private byte[] payload = null;

        public void detectedFrameSize(int size) {
        }

        public void onText(byte[] tempByteBuffer, int length) {
            frameType = "text";

            payload = new byte[length];
            System.arraycopy(tempByteBuffer, 0, payload, 0, length);
        }

        public void onBinary(byte[] tempByteBuffer, int length) {
            frameType = "binary";

            payload = new byte[length];
            System.arraycopy(tempByteBuffer, 0, payload, 0, length);
        }

        public void onClose() {
            isStreamClosed = true;
        }
    }

    //--------------------------------------------------------------------------
    public void detectedNewStream(ThreadContext tc, Connection conn, WebSocketStream newStream) throws Throwable {
        newStream.writeText("服务器：成功建立WS流。".getBytes());
    }

    public boolean invoke(ThreadContext tc, Connection conn, WebSocketStream readableStream) throws Throwable {
        TempWebSocketListener listener = new TempWebSocketListener();
        readableStream.read(listener, tc.getTempByteBuffer());

        if (listener.isStreamClosed) {
            readableStream.close();
            return false;
        }

        final String command = new String(listener.payload);

        final String s1 = "服务器：浏览器使用" + listener.frameType + "类型帧发送"
                + command + "命令给qhs，qhs执行" + command + "命令的结果：";

        String s2 = new String();

        if ("time".equals(command)) {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(Calendar.YEAR);
            int month = cal.get(Calendar.MONTH) + 1;
            int day = cal.get(Calendar.DAY_OF_MONTH);
            int hour = cal.get(Calendar.HOUR_OF_DAY);
            int minute = cal.get(Calendar.MINUTE);
            int second = cal.get(Calendar.SECOND);

            s2 = year + "/" + month + "/" + day + " " + hour + ":" + minute + ":" + second;

        } else if ("vmversion".equals(command)) {

            s2 = System.getProperty("java.vm.version");

        } else if ("cpucount".equals(command)) {
            s2 = java.lang.Runtime.getRuntime().availableProcessors() + "个CPU";

        } else if ("freemem".equals(command)) {
            s2 = java.lang.Runtime.getRuntime().freeMemory() + "个字节";

        } else if ("totalmem".equals(command)) {
            s2 = java.lang.Runtime.getRuntime().totalMemory() + "个字节";

        } else /*if ("help".equals(comm))*/ {
            s2 = "操作方法：选择\"WebSocket帧类型\" -> 选择\"命令\" -> 单击\"执行\"按钮";
        }

        String s3 = s1 + s2;

        if (listener.frameType.equals("text")) {
            readableStream.writeText(s3.getBytes());
        } else {
            readableStream.writeBinary(s3.getBytes());
        }

        return false;
    }

    public String update(String arg0) throws Throwable {
        return null;
    }

    public void clear() throws Throwable {
    }

}
