package sendingthread;

import java.nio.file.*;
import qhs.interfaces.WebSocketStream;
import qhs.interfaces.WebSocketCode;
import qhs.interfaces.ServerStatus;

public class SendingThread extends Thread {

    private final ServerStatus serverStatus;

    public SendingThread(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    private static class TempWebSocketCode implements WebSocketCode {

        private String values = null;

        public void invoke(WebSocketStream stream) {
            try {
                StreamState state = (StreamState) stream.getUserObject();
                if (state.paused) {
                    return;
                }

                state.times++;
                stream.writeText(("2" + values + "," + state.times).getBytes());
            } catch (Throwable exc) {
                stream.close();
            }
        }
    };

    public void run() {
        final TempWebSocketCode wsc = new TempWebSocketCode();
        long startTime = System.currentTimeMillis();
        long endTime = 0L;

        while (!serverStatus.isServerExiting()) {
            while ((endTime = System.currentTimeMillis()) - startTime < 300L) {
                try {
                    Thread.sleep(30L);
                } catch (Throwable exc) {
                }

                Thread.yield();
                continue;
            }

            startTime = endTime;
            String values = new String();

            try {
                //从/proc/meminfo文件读取6个变量值。
                String content = new String(Files.readAllBytes(Paths.get("/proc/meminfo")));
                int beginIndex = 0;
                for (int i = 0; i < 6; i++) {
                    if (!values.isEmpty()) {
                        values = values + ',';
                    }

                    final int endIndex = content.indexOf("\n", beginIndex);
                    String s = content.substring(beginIndex, endIndex);

                    s = s.substring(0, s.lastIndexOf('\u0020'));
                    values += s.substring(s.lastIndexOf('\u0020') + 1) + "kB";

                    beginIndex = endIndex + 1;
                }

            } catch (Throwable exc) {
            }

            for (int i = 0; i < WebSocketStreamList.count();) {
                WebSocketStream stream = WebSocketStreamList.get(i);

                if (stream.isClosed()) {
                    WebSocketStreamList.remove(i);
                    continue;
                }

                try {
                    wsc.values = values;
                    stream.invoke(wsc);
                } catch (Throwable exc) {
                }

                i++;
                Thread.yield();
            }
        }

    }
}
