package sendingthread;

import java.util.ArrayList;
import qhs.interfaces.WebSocketStream;
import qhs.interfaces.ServerStatus;

public class WebSocketStreamList {

    private static final ArrayList<WebSocketStream> list = new ArrayList();
    private static SendingThread thread = null;

    public static synchronized void add(WebSocketStream stream, ServerStatus serverStatus) {

        if (thread == null) {
            thread = new SendingThread(serverStatus);
            thread.start();
        }

        list.add(stream);
    }

    public static synchronized WebSocketStream get(int index) {
        if (0 <= index && index < list.size()) {
            return list.get(index);
        }

        return null;
    }

    public static synchronized void remove(int index) {
        if (0 <= index && index < list.size()) {
            list.remove(index);
        }
    }

    public static synchronized int count() {
        return list.size();
    }
}
