package wsServiceModule;

import java.util.Calendar;
import qhs.interfaces.Connection;
import qhs.interfaces.ThreadContext;
import qhs.interfaces.WebSocketCode;
import qhs.interfaces.WebSocketStream;
import sendingthread.StreamState;
import sendingthread.WebSocketStreamList;

public class WSServiceModule implements qhs.interfaces.WSServiceModule {

    private static class TempWebSocketListener implements qhs.interfaces.WebSocketListener {

        private boolean isStreamClosed = false;
        private byte[] payload = null;

        public void detectedFrameSize(int size) {
        }

        public void onText(byte[] tempByteBuffer, int length) {
            payload = new byte[length];
            System.arraycopy(tempByteBuffer, 0, payload, 0, length);
        }

        public void onBinary(byte[] tempByteBuffer, int length) {
            payload = new byte[length];
            System.arraycopy(tempByteBuffer, 0, payload, 0, length);
        }

        public void onClose() {
            isStreamClosed = true;
        }
    }

    private static class TempWebSocketCode implements WebSocketCode {

        private boolean paused = false;

        public void invoke(WebSocketStream stream) {
            StreamState state = (StreamState) stream.getUserObject();
            state.paused = paused;
        }
    };

    //--------------------------------------------------------------------------
    public void detectedNewStream(ThreadContext tc, Connection conn, WebSocketStream newStream) throws Throwable {
        newStream.setUserObject(new StreamState());
        newStream.writeText("1成功建立WS流。".getBytes());
        WebSocketStreamList.add(newStream, tc.getServerStatus());
    }

    private final TempWebSocketCode wsc = new TempWebSocketCode();

    public boolean invoke(ThreadContext tc, Connection conn, WebSocketStream readableStream) throws Throwable {

        TempWebSocketListener listener = new TempWebSocketListener();
        readableStream.read(listener, tc.getTempByteBuffer());

        if (listener.isStreamClosed) {
            readableStream.close();
            return false;
        }

        final String command = new String(listener.payload);
        if ("pause".equals(command)) {
            wsc.paused = true;
            readableStream.invoke(wsc);

        } else if ("resume".equals(command)) {
            wsc.paused = false;
            readableStream.invoke(wsc);
        }

        return true;
    }

    public String update(String arg0) throws Throwable {
        return null;
    }

    public void clear() throws Throwable {
    }

}
