/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import ch.qos.logback.classic.spi.d;
import ch.qos.logback.classic.spi.e;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.c;

public class LoggingEventVO
implements d,
Serializable {
    private static final long serialVersionUID = 6553722650255690312L;
    private static final int io = -1;
    private static final String ip = "NULL_ARGUMENT_ARRAY_ELEMENT";
    private static final int iq = 128;
    private String threadName;
    private String loggerName;
    private LoggerContextVO loggerContextVO;
    private transient Level dO;
    private String message;
    private transient String ig;
    private transient Object[] ih;
    private ThrowableProxyVO throwableProxy;
    private StackTraceElement[] callerDataArray;
    private List<Marker> markerList;
    private List<c> keyValuePairList;
    private Map<String, String> mdcPropertyMap;
    private long timestamp;
    private int nanoseconds;
    private long sequenceNumber;

    public static LoggingEventVO build(d le) {
        LoggingEventVO ledo = new LoggingEventVO();
        ledo.loggerName = le.getLoggerName();
        ledo.loggerContextVO = le.getLoggerContextVO();
        ledo.threadName = le.getThreadName();
        ledo.dO = le.getLevel();
        ledo.message = le.getMessage();
        ledo.ih = le.getArgumentArray();
        ledo.markerList = le.getMarkerList();
        ledo.keyValuePairList = le.getKeyValuePairs();
        ledo.mdcPropertyMap = le.getMDCPropertyMap();
        ledo.timestamp = le.getTimeStamp();
        ledo.nanoseconds = le.getNanoseconds();
        ledo.sequenceNumber = le.getSequenceNumber();
        ledo.throwableProxy = ThrowableProxyVO.build(le.getThrowableProxy());
        if (le.hasCallerData()) {
            ledo.callerDataArray = le.getCallerData();
        }
        return ledo;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Level getLevel() {
        return this.dO;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getFormattedMessage() {
        if (this.ig != null) {
            return this.ig;
        }
        this.ig = this.ih != null ? org.slf4j.helpers.e.a(this.message, this.ih).getMessage() : this.message;
        return this.ig;
    }

    @Override
    public Object[] getArgumentArray() {
        return this.ih;
    }

    @Override
    public e getThrowableProxy() {
        return this.throwableProxy;
    }

    @Override
    public StackTraceElement[] getCallerData() {
        return this.callerDataArray;
    }

    @Override
    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    @Override
    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public int getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    public LoggerContextVO getContextLoggerRemoteView() {
        return this.loggerContextVO;
    }

    @Override
    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    @Override
    public Map<String, String> getMdc() {
        return this.mdcPropertyMap;
    }

    @Override
    public List<c> getKeyValuePairs() {
        return this.keyValuePairList;
    }

    @Override
    public void prepareForDeferredProcessing() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.dO.levelInt);
        if (this.ih != null) {
            int len = this.ih.length;
            out.writeInt(len);
            for (int i2 = 0; i2 < this.ih.length; ++i2) {
                if (this.ih[i2] != null) {
                    out.writeObject(this.ih[i2].toString());
                    continue;
                }
                out.writeObject(ip);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int levelInt = in.readInt();
        this.dO = Level.toLevel(levelInt);
        int argArrayLen = in.readInt();
        if (argArrayLen < -1 || argArrayLen > 128) {
            throw new InvalidObjectException("Argument array length is invalid: " + argArrayLen);
        }
        if (argArrayLen != -1) {
            this.ih = new String[argArrayLen];
            for (int i2 = 0; i2 < argArrayLen; ++i2) {
                Object val = in.readObject();
                if (ip.equals(val)) continue;
                this.ih[i2] = val;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        long millis = this.getTimeStamp();
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.threadName == null ? 0 : this.threadName.hashCode());
        result = 31 * result + (int)(millis ^ millis >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoggingEventVO other = (LoggingEventVO)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.loggerName == null ? other.loggerName != null : !this.loggerName.equals(other.loggerName)) {
            return false;
        }
        if (this.threadName == null ? other.threadName != null : !this.threadName.equals(other.threadName)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.markerList == null ? other.markerList != null : !this.markerList.equals(other.markerList)) {
            return false;
        }
        return !(this.mdcPropertyMap == null ? other.mdcPropertyMap != null : !this.mdcPropertyMap.equals(other.mdcPropertyMap));
    }
}

