/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ToNumberPolicy;
import com.google.gson.c;
import com.google.gson.d;
import com.google.gson.e;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.b;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.NumberTypeAdapter;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.SerializationDelegatingTypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.i;
import com.google.gson.internal.k;
import com.google.gson.internal.sql.a;
import com.google.gson.j;
import com.google.gson.q;
import com.google.gson.r;
import com.google.gson.s;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public final class Gson {
    static final boolean AQ = false;
    static final boolean AR = false;
    static final boolean AS = false;
    static final boolean AU = true;
    static final boolean AV = false;
    static final boolean AW = false;
    static final boolean AX = false;
    static final boolean AY = true;
    static final String AZ = null;
    static final c Ba = FieldNamingPolicy.IDENTITY;
    static final q Bb = ToNumberPolicy.DOUBLE;
    static final q Bc = ToNumberPolicy.LAZILY_PARSED_NUMBER;
    private static final String Bd = ")]}'\n";
    private final ThreadLocal<Map<com.google.gson.b.a<?>, r<?>>> Be = new ThreadLocal();
    private final ConcurrentMap<com.google.gson.b.a<?>, r<?>> Bf = new ConcurrentHashMap();
    private final b Bg;
    private final JsonAdapterAnnotationTypeAdapterFactory Bh;
    final List<s> Bi;
    final Excluder Bj;
    final c Bk;
    final Map<Type, e<?>> Bl;
    final boolean Bm;
    final boolean Bn;
    final boolean Bo;
    final boolean Bp;
    final boolean Bq;
    final boolean Br;
    final boolean Bs;
    final boolean Bt;
    final String Bu;
    final int Bv;
    final int Bw;
    final LongSerializationPolicy Bx;
    final List<s> By;
    final List<s> Bz;
    final q BA;
    final q BD;
    final List<ReflectionAccessFilter> BE;

    public Gson() {
        this(Excluder.CC, Ba, Collections.emptyMap(), false, false, false, true, false, false, false, true, LongSerializationPolicy.DEFAULT, AZ, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Bb, Bc, Collections.emptyList());
    }

    Gson(Excluder excluder, c fieldNamingStrategy, Map<Type, e<?>> instanceCreators, boolean serializeNulls, boolean complexMapKeySerialization, boolean generateNonExecutableGson, boolean htmlSafe, boolean prettyPrinting, boolean lenient, boolean serializeSpecialFloatingPointValues, boolean useJdkUnsafe, LongSerializationPolicy longSerializationPolicy, String datePattern, int dateStyle, int timeStyle, List<s> builderFactories, List<s> builderHierarchyFactories, List<s> factoriesToBeAdded, q objectToNumberStrategy, q numberToNumberStrategy, List<ReflectionAccessFilter> reflectionFilters) {
        this.Bj = excluder;
        this.Bk = fieldNamingStrategy;
        this.Bl = instanceCreators;
        this.Bg = new b(instanceCreators, useJdkUnsafe, reflectionFilters);
        this.Bm = serializeNulls;
        this.Bn = complexMapKeySerialization;
        this.Bo = generateNonExecutableGson;
        this.Bp = htmlSafe;
        this.Bq = prettyPrinting;
        this.Br = lenient;
        this.Bs = serializeSpecialFloatingPointValues;
        this.Bt = useJdkUnsafe;
        this.Bx = longSerializationPolicy;
        this.Bu = datePattern;
        this.Bv = dateStyle;
        this.Bw = timeStyle;
        this.By = builderFactories;
        this.Bz = builderHierarchyFactories;
        this.BA = objectToNumberStrategy;
        this.BD = numberToNumberStrategy;
        this.BE = reflectionFilters;
        ArrayList<s> factories = new ArrayList<s>();
        factories.add(TypeAdapters.Ge);
        factories.add(ObjectTypeAdapter.d(objectToNumberStrategy));
        factories.add(excluder);
        factories.addAll(factoriesToBeAdded);
        factories.add(TypeAdapters.FI);
        factories.add(TypeAdapters.Fs);
        factories.add(TypeAdapters.Fm);
        factories.add(TypeAdapters.Fo);
        factories.add(TypeAdapters.Fq);
        r<Number> longAdapter = Gson.a(longSerializationPolicy);
        factories.add(TypeAdapters.a(Long.TYPE, Long.class, longAdapter));
        factories.add(TypeAdapters.a(Double.TYPE, Double.class, this.F(serializeSpecialFloatingPointValues)));
        factories.add(TypeAdapters.a(Float.TYPE, Float.class, this.G(serializeSpecialFloatingPointValues)));
        factories.add(NumberTypeAdapter.d(numberToNumberStrategy));
        factories.add(TypeAdapters.Fu);
        factories.add(TypeAdapters.Fw);
        factories.add(TypeAdapters.a(AtomicLong.class, Gson.a(longAdapter)));
        factories.add(TypeAdapters.a(AtomicLongArray.class, Gson.b(longAdapter)));
        factories.add(TypeAdapters.Fy);
        factories.add(TypeAdapters.FD);
        factories.add(TypeAdapters.FL);
        factories.add(TypeAdapters.FN);
        factories.add(TypeAdapters.a(BigDecimal.class, TypeAdapters.FF));
        factories.add(TypeAdapters.a(BigInteger.class, TypeAdapters.FG));
        factories.add(TypeAdapters.a(LazilyParsedNumber.class, TypeAdapters.FH));
        factories.add(TypeAdapters.FP);
        factories.add(TypeAdapters.FS);
        factories.add(TypeAdapters.FW);
        factories.add(TypeAdapters.FY);
        factories.add(TypeAdapters.Gc);
        factories.add(TypeAdapters.FU);
        factories.add(TypeAdapters.Fj);
        factories.add(DateTypeAdapter.DE);
        factories.add(TypeAdapters.Ga);
        if (a.GT) {
            factories.add(a.GX);
            factories.add(a.GW);
            factories.add(a.GY);
        }
        factories.add(ArrayTypeAdapter.Dx);
        factories.add(TypeAdapters.Fh);
        factories.add(new CollectionTypeAdapterFactory(this.Bg));
        factories.add(new MapTypeAdapterFactory(this.Bg, complexMapKeySerialization));
        this.Bh = new JsonAdapterAnnotationTypeAdapterFactory(this.Bg);
        factories.add(this.Bh);
        factories.add(TypeAdapters.Gf);
        factories.add(new ReflectiveTypeAdapterFactory(this.Bg, fieldNamingStrategy, excluder, this.Bh, reflectionFilters));
        this.Bi = Collections.unmodifiableList(factories);
    }

    public d jF() {
        return new d(this);
    }

    @Deprecated
    public Excluder jG() {
        return this.Bj;
    }

    public c jH() {
        return this.Bk;
    }

    public boolean jI() {
        return this.Bm;
    }

    public boolean jJ() {
        return this.Bp;
    }

    private r<Number> F(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.FB;
        }
        return new r<Number>(){

            public Double a(com.google.gson.stream.a in) throws IOException {
                if (in.kX() == JsonToken.NULL) {
                    in.ld();
                    return null;
                }
                return in.le();
            }

            @Override
            public void a(com.google.gson.stream.c out, Number value) throws IOException {
                if (value == null) {
                    out.lq();
                    return;
                }
                double doubleValue = value.doubleValue();
                Gson.h(doubleValue);
                out.k(doubleValue);
            }

            @Override
            public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
                return this.a(a2);
            }
        };
    }

    private r<Number> G(boolean serializeSpecialFloatingPointValues) {
        if (serializeSpecialFloatingPointValues) {
            return TypeAdapters.FA;
        }
        return new r<Number>(){

            public Float c(com.google.gson.stream.a in) throws IOException {
                if (in.kX() == JsonToken.NULL) {
                    in.ld();
                    return null;
                }
                return Float.valueOf((float)in.le());
            }

            @Override
            public void a(com.google.gson.stream.c out, Number value) throws IOException {
                if (value == null) {
                    out.lq();
                    return;
                }
                float floatValue = value.floatValue();
                Gson.h(floatValue);
                Number floatNumber = value instanceof Float ? (Number)value : (Number)Float.valueOf(floatValue);
                out.b(floatNumber);
            }

            @Override
            public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
                return this.c(a2);
            }
        };
    }

    static void h(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException(value + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static r<Number> a(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.Fz;
        }
        return new r<Number>(){

            public Number d(com.google.gson.stream.a in) throws IOException {
                if (in.kX() == JsonToken.NULL) {
                    in.ld();
                    return null;
                }
                return in.nextLong();
            }

            @Override
            public void a(com.google.gson.stream.c out, Number value) throws IOException {
                if (value == null) {
                    out.lq();
                    return;
                }
                out.cQ(value.toString());
            }

            @Override
            public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
                return this.d(a2);
            }
        };
    }

    private static r<AtomicLong> a(final r<Number> longAdapter) {
        return new r<AtomicLong>(){

            @Override
            public void a(com.google.gson.stream.c out, AtomicLong value) throws IOException {
                longAdapter.a(out, Long.valueOf(value.get()));
            }

            public AtomicLong e(com.google.gson.stream.a in) throws IOException {
                Number value = (Number)longAdapter.b(in);
                return new AtomicLong(value.longValue());
            }

            @Override
            public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
                return this.e(a2);
            }
        }.kB();
    }

    private static r<AtomicLongArray> b(final r<Number> longAdapter) {
        return new r<AtomicLongArray>(){

            @Override
            public void a(com.google.gson.stream.c out, AtomicLongArray value) throws IOException {
                out.lm();
                int length = value.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    longAdapter.a(out, Long.valueOf(value.get(i2)));
                }
                out.ln();
            }

            public AtomicLongArray f(com.google.gson.stream.a in) throws IOException {
                ArrayList<Long> list = new ArrayList<Long>();
                in.kT();
                while (in.hasNext()) {
                    long value = ((Number)longAdapter.b(in)).longValue();
                    list.add(value);
                }
                in.kU();
                int length = list.size();
                AtomicLongArray array = new AtomicLongArray(length);
                for (int i2 = 0; i2 < length; ++i2) {
                    array.set(i2, (Long)list.get(i2));
                }
                return array;
            }

            @Override
            public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
                return this.f(a2);
            }
        }.kB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> r<T> a(com.google.gson.b.a<T> type) {
        Objects.requireNonNull(type, "type must not be null");
        r cached = (r)this.Bf.get(type);
        if (cached != null) {
            r adapter = cached;
            return adapter;
        }
        Map<com.google.gson.b.a<?>, r<?>> threadCalls = this.Be.get();
        boolean isInitialAdapterRequest = false;
        if (threadCalls == null) {
            threadCalls = new HashMap();
            this.Be.set(threadCalls);
            isInitialAdapterRequest = true;
        } else {
            r<?> ongoingCall = threadCalls.get(type);
            if (ongoingCall != null) {
                return ongoingCall;
            }
        }
        r<T> candidate = null;
        try {
            FutureTypeAdapter<T> call = new FutureTypeAdapter<T>();
            threadCalls.put(type, call);
            for (s factory : this.Bi) {
                candidate = factory.a(this, type);
                if (candidate == null) continue;
                call.c(candidate);
                threadCalls.put(type, candidate);
                break;
            }
        }
        finally {
            if (isInitialAdapterRequest) {
                this.Be.remove();
            }
        }
        if (candidate == null) {
            throw new IllegalArgumentException("GSON (2.10.1) cannot handle " + type);
        }
        if (isInitialAdapterRequest) {
            this.Bf.putAll(threadCalls);
        }
        return candidate;
    }

    public <T> r<T> a(s skipPast, com.google.gson.b.a<T> type) {
        if (!this.Bi.contains(skipPast)) {
            skipPast = this.Bh;
        }
        boolean skipPastFound = false;
        for (s factory : this.Bi) {
            if (!skipPastFound) {
                if (factory != skipPast) continue;
                skipPastFound = true;
                continue;
            }
            r<T> candidate = factory.a(this, type);
            if (candidate == null) continue;
            return candidate;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + type);
    }

    public <T> r<T> w(Class<T> type) {
        return this.a(com.google.gson.b.a.Q(type));
    }

    public com.google.gson.i R(Object src) {
        if (src == null) {
            return j.BR;
        }
        return this.a(src, src.getClass());
    }

    public com.google.gson.i a(Object src, Type typeOfSrc) {
        com.google.gson.internal.bind.b writer = new com.google.gson.internal.bind.b();
        this.a(src, typeOfSrc, writer);
        return writer.lk();
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.a(j.BR);
        }
        return this.b(src, src.getClass());
    }

    public String b(Object src, Type typeOfSrc) {
        StringWriter writer = new StringWriter();
        this.a(src, typeOfSrc, writer);
        return writer.toString();
    }

    public void a(Object src, Appendable writer) throws JsonIOException {
        if (src != null) {
            this.a(src, src.getClass(), writer);
        } else {
            this.a((com.google.gson.i)j.BR, writer);
        }
    }

    public void a(Object src, Type typeOfSrc, Appendable writer) throws JsonIOException {
        try {
            com.google.gson.stream.c jsonWriter = this.a(k.a(writer));
            this.a(src, typeOfSrc, jsonWriter);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
    }

    public void a(Object src, Type typeOfSrc, com.google.gson.stream.c writer) throws JsonIOException {
        r<?> adapter = this.a(com.google.gson.b.a.m(typeOfSrc));
        boolean oldLenient = writer.ly();
        writer.N(true);
        boolean oldHtmlSafe = writer.lI();
        writer.O(this.Bp);
        boolean oldSerializeNulls = writer.lJ();
        writer.P(this.Bm);
        try {
            adapter.a(writer, src);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
        catch (AssertionError e3) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e3)).getMessage(), (Throwable)((Object)e3));
        }
        finally {
            writer.N(oldLenient);
            writer.O(oldHtmlSafe);
            writer.P(oldSerializeNulls);
        }
    }

    public String a(com.google.gson.i jsonElement) {
        StringWriter writer = new StringWriter();
        this.a(jsonElement, (Appendable)writer);
        return writer.toString();
    }

    public void a(com.google.gson.i jsonElement, Appendable writer) throws JsonIOException {
        try {
            com.google.gson.stream.c jsonWriter = this.a(k.a(writer));
            this.a(jsonElement, jsonWriter);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
    }

    public com.google.gson.stream.c a(Writer writer) throws IOException {
        if (this.Bo) {
            writer.write(Bd);
        }
        com.google.gson.stream.c jsonWriter = new com.google.gson.stream.c(writer);
        if (this.Bq) {
            jsonWriter.cU("  ");
        }
        jsonWriter.O(this.Bp);
        jsonWriter.N(this.Br);
        jsonWriter.P(this.Bm);
        return jsonWriter;
    }

    public com.google.gson.stream.a a(Reader reader) {
        com.google.gson.stream.a jsonReader = new com.google.gson.stream.a(reader);
        jsonReader.L(this.Br);
        return jsonReader;
    }

    public void a(com.google.gson.i jsonElement, com.google.gson.stream.c writer) throws JsonIOException {
        boolean oldLenient = writer.ly();
        writer.N(true);
        boolean oldHtmlSafe = writer.lI();
        writer.O(this.Bp);
        boolean oldSerializeNulls = writer.lJ();
        writer.P(this.Bm);
        try {
            k.b(jsonElement, writer);
        }
        catch (IOException e2) {
            throw new JsonIOException(e2);
        }
        catch (AssertionError e3) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e3)).getMessage(), (Throwable)((Object)e3));
        }
        finally {
            writer.N(oldLenient);
            writer.O(oldHtmlSafe);
            writer.P(oldSerializeNulls);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        T object = this.a(json, com.google.gson.b.a.Q(classOfT));
        return i.E(classOfT).cast(object);
    }

    public <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        return (T)this.a(json, com.google.gson.b.a.m(typeOfT));
    }

    public <T> T a(String json, com.google.gson.b.a<T> typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        StringReader reader = new StringReader(json);
        return this.a((Reader)reader, typeOfT);
    }

    public <T> T a(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        T object = this.a(json, com.google.gson.b.a.Q(classOfT));
        return i.E(classOfT).cast(object);
    }

    public <T> T a(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)this.a(json, com.google.gson.b.a.m(typeOfT));
    }

    public <T> T a(Reader json, com.google.gson.b.a<T> typeOfT) throws JsonIOException, JsonSyntaxException {
        com.google.gson.stream.a jsonReader = this.a(json);
        T object = this.a(jsonReader, typeOfT);
        Gson.a(object, jsonReader);
        return object;
    }

    private static void a(Object obj, com.google.gson.stream.a reader) {
        try {
            if (obj != null && reader.kX() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException e2) {
            throw new JsonSyntaxException(e2);
        }
        catch (IOException e3) {
            throw new JsonIOException(e3);
        }
    }

    public <T> T a(com.google.gson.stream.a reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)this.a(reader, com.google.gson.b.a.m(typeOfT));
    }

    public <T> T a(com.google.gson.stream.a reader, com.google.gson.b.a<T> typeOfT) throws JsonIOException, JsonSyntaxException {
        boolean isEmpty = true;
        boolean oldLenient = reader.ly();
        reader.L(true);
        try {
            reader.kX();
            isEmpty = false;
            r<T> typeAdapter = this.a(typeOfT);
            T t2 = typeAdapter.b(reader);
            return t2;
        }
        catch (EOFException e2) {
            if (isEmpty) {
                T t3 = null;
                return t3;
            }
            throw new JsonSyntaxException(e2);
        }
        catch (IllegalStateException e3) {
            throw new JsonSyntaxException(e3);
        }
        catch (IOException e4) {
            throw new JsonSyntaxException(e4);
        }
        catch (AssertionError e5) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)e5)).getMessage(), (Throwable)((Object)e5));
        }
        finally {
            reader.L(oldLenient);
        }
    }

    public <T> T a(com.google.gson.i json, Class<T> classOfT) throws JsonSyntaxException {
        T object = this.a(json, com.google.gson.b.a.Q(classOfT));
        return i.E(classOfT).cast(object);
    }

    public <T> T a(com.google.gson.i json, Type typeOfT) throws JsonSyntaxException {
        return (T)this.a(json, com.google.gson.b.a.m(typeOfT));
    }

    public <T> T a(com.google.gson.i json, com.google.gson.b.a<T> typeOfT) throws JsonSyntaxException {
        if (json == null) {
            return null;
        }
        return this.a((com.google.gson.stream.a)new com.google.gson.internal.bind.a(json), typeOfT);
    }

    public String toString() {
        return "{serializeNulls:" + this.Bm + ",factories:" + this.Bi + ",instanceCreators:" + this.Bg + "}";
    }

    static class FutureTypeAdapter<T>
    extends SerializationDelegatingTypeAdapter<T> {
        private r<T> BJ = null;

        FutureTypeAdapter() {
        }

        public void c(r<T> typeAdapter) {
            if (this.BJ != null) {
                throw new AssertionError((Object)"Delegate is already set");
            }
            this.BJ = typeAdapter;
        }

        private r<T> jK() {
            r<T> delegate = this.BJ;
            if (delegate == null) {
                throw new IllegalStateException("Adapter for type with cyclic dependency has been used before dependency has been resolved");
            }
            return delegate;
        }

        @Override
        public r<T> jL() {
            return this.jK();
        }

        @Override
        public T b(com.google.gson.stream.a in) throws IOException {
            return this.jK().b(in);
        }

        @Override
        public void a(com.google.gson.stream.c out, T value) throws IOException {
            this.jK().a(out, value);
        }
    }
}

