/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.q;
import com.google.gson.stream.MalformedJsonException;
import com.google.gson.stream.a;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements q
{
    DOUBLE{

        @Override
        public Double readNumber(a in) throws IOException {
            return in.le();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(a in) throws IOException {
            return new LazilyParsedNumber(in.lb());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(a in) throws IOException, JsonParseException {
            String value = in.lb();
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException longE) {
                try {
                    Double d2 = Double.valueOf(value);
                    if ((d2.isInfinite() || d2.isNaN()) && !in.ly()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + "; at path " + in.li());
                    }
                    return d2;
                }
                catch (NumberFormatException doubleE) {
                    throw new JsonParseException("Cannot parse " + value + "; at path " + in.li(), doubleE);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(a in) throws IOException {
            String value = in.lb();
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e2) {
                throw new JsonParseException("Cannot parse " + value + "; at path " + in.li(), e2);
            }
        }
    };

}

