/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> CU = new Comparator<Comparable>(){

        public int a(Comparable a2, Comparable b2) {
            return a2.compareTo(b2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Comparable)object, (Comparable)object2);
        }
    };
    private final Comparator<? super K> comparator;
    private final boolean allowNullValues;
    d<K, V> root;
    int size = 0;
    int modCount = 0;
    final d<K, V> header;
    private a entrySet;
    private b keySet;

    public LinkedTreeMap() {
        this(CU, true);
    }

    public LinkedTreeMap(boolean allowNullValues) {
        this(CU, allowNullValues);
    }

    public LinkedTreeMap(Comparator<? super K> comparator, boolean allowNullValues) {
        this.comparator = comparator != null ? comparator : CU;
        this.allowNullValues = allowNullValues;
        this.header = new d(allowNullValues);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object key) {
        d<K, V> node = this.findByObject(key);
        return node != null ? (V)node.value : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByObject(key) != null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null && !this.allowNullValues) {
            throw new NullPointerException("value == null");
        }
        d<K, V> created = this.find(key, true);
        Object result = created.value;
        created.value = value;
        return result;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
        d<K, V> header = this.header;
        header.Dg = header;
        header.CZ = header.Dg;
    }

    @Override
    public V remove(Object key) {
        d<K, V> node = this.removeInternalByKey(key);
        return node != null ? (V)node.value : null;
    }

    d<K, V> find(K key, boolean create) {
        d<K, V> created;
        Comparator<K> comparator = this.comparator;
        d<K, V> nearest = this.root;
        int comparison = 0;
        if (nearest != null) {
            Comparable comparableKey = comparator == CU ? (Comparable)key : null;
            while (true) {
                d child;
                int n2 = comparison = comparableKey != null ? comparableKey.compareTo(nearest.Dh) : comparator.compare(key, nearest.Dh);
                if (comparison == 0) {
                    return nearest;
                }
                d d2 = child = comparison < 0 ? nearest.De : nearest.Df;
                if (child == null) break;
                nearest = child;
            }
        }
        if (!create) {
            return null;
        }
        d<K, V> header = this.header;
        if (nearest == null) {
            if (comparator == CU && !(key instanceof Comparable)) {
                throw new ClassCastException(key.getClass().getName() + " is not Comparable");
            }
            created = new d<K, V>(this.allowNullValues, nearest, key, header, header.Dg);
            this.root = created;
        } else {
            created = new d<K, V>(this.allowNullValues, nearest, key, header, header.Dg);
            if (comparison < 0) {
                nearest.De = created;
            } else {
                nearest.Df = created;
            }
            this.a(nearest, true);
        }
        ++this.size;
        ++this.modCount;
        return created;
    }

    d<K, V> findByObject(Object key) {
        try {
            return key != null ? this.find(key, false) : null;
        }
        catch (ClassCastException e2) {
            return null;
        }
    }

    d<K, V> findByEntry(Map.Entry<?, ?> entry) {
        d<K, V> mine = this.findByObject(entry.getKey());
        boolean valuesEqual = mine != null && this.a(mine.value, entry.getValue());
        return valuesEqual ? mine : null;
    }

    private boolean a(Object a2, Object b2) {
        return Objects.equals(a2, b2);
    }

    void removeInternal(d<K, V> node, boolean unlink) {
        if (unlink) {
            node.Dg.CZ = node.CZ;
            node.CZ.Dg = node.Dg;
        }
        d left = node.De;
        d right = node.Df;
        d originalParent = node.Dd;
        if (left != null && right != null) {
            d adjacent = left.height > right.height ? left.kQ() : right.kP();
            this.removeInternal(adjacent, false);
            int leftHeight = 0;
            left = node.De;
            if (left != null) {
                leftHeight = left.height;
                adjacent.De = left;
                left.Dd = adjacent;
                node.De = null;
            }
            int rightHeight = 0;
            right = node.Df;
            if (right != null) {
                rightHeight = right.height;
                adjacent.Df = right;
                right.Dd = adjacent;
                node.Df = null;
            }
            adjacent.height = Math.max(leftHeight, rightHeight) + 1;
            this.a(node, adjacent);
            return;
        }
        if (left != null) {
            this.a(node, left);
            node.De = null;
        } else if (right != null) {
            this.a(node, right);
            node.Df = null;
        } else {
            this.a(node, null);
        }
        this.a(originalParent, false);
        --this.size;
        ++this.modCount;
    }

    d<K, V> removeInternalByKey(Object key) {
        d<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node, true);
        }
        return node;
    }

    private void a(d<K, V> node, d<K, V> replacement) {
        d parent = node.Dd;
        node.Dd = null;
        if (replacement != null) {
            replacement.Dd = parent;
        }
        if (parent != null) {
            if (parent.De == node) {
                parent.De = replacement;
            } else {
                assert (parent.Df == node);
                parent.Df = replacement;
            }
        } else {
            this.root = replacement;
        }
    }

    private void a(d<K, V> unbalanced, boolean insert) {
        d<K, V> node = unbalanced;
        while (node != null) {
            d right;
            int rightHeight;
            d left = node.De;
            int leftHeight = left != null ? left.height : 0;
            int delta = leftHeight - (rightHeight = (right = node.Df) != null ? right.height : 0);
            if (delta == -2) {
                d rightRight;
                int rightRightHeight;
                d rightLeft = right.De;
                int rightLeftHeight = rightLeft != null ? rightLeft.height : 0;
                int rightDelta = rightLeftHeight - (rightRightHeight = (rightRight = right.Df) != null ? rightRight.height : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.a(node);
                } else {
                    assert (rightDelta == 1);
                    this.b(right);
                    this.a(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 2) {
                d leftRight;
                int leftRightHeight;
                d leftLeft = left.De;
                int leftLeftHeight = leftLeft != null ? leftLeft.height : 0;
                int leftDelta = leftLeftHeight - (leftRightHeight = (leftRight = left.Df) != null ? leftRight.height : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.b(node);
                } else {
                    assert (leftDelta == -1);
                    this.a(left);
                    this.b(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 0) {
                node.height = leftHeight + 1;
                if (insert) {
                    break;
                }
            } else {
                assert (delta == -1 || delta == 1);
                node.height = Math.max(leftHeight, rightHeight) + 1;
                if (!insert) break;
            }
            node = node.Dd;
        }
    }

    private void a(d<K, V> root) {
        d left = root.De;
        d pivot = root.Df;
        d pivotLeft = pivot.De;
        d pivotRight = pivot.Df;
        root.Df = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.Dd = root;
        }
        this.a(root, pivot);
        pivot.De = root;
        root.Dd = pivot;
        root.height = Math.max(left != null ? left.height : 0, pivotLeft != null ? pivotLeft.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotRight != null ? pivotRight.height : 0) + 1;
    }

    private void b(d<K, V> root) {
        d pivot = root.De;
        d right = root.Df;
        d pivotLeft = pivot.De;
        d pivotRight = pivot.Df;
        root.De = pivotRight;
        if (pivotRight != null) {
            pivotRight.Dd = root;
        }
        this.a(root, pivot);
        pivot.Df = root;
        root.Dd = pivot;
        root.height = Math.max(right != null ? right.height : 0, pivotRight != null ? pivotRight.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotLeft != null ? pivotLeft.height : 0) + 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        a result = this.entrySet;
        return result != null ? result : (this.entrySet = new a());
    }

    @Override
    public Set<K> keySet() {
        b result = this.keySet;
        return result != null ? result : (this.keySet = new b());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Deserialization is unsupported");
    }

    final class b
    extends AbstractSet<K> {
        b() {
        }

        @Override
        public int size() {
            return LinkedTreeMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new c(){

                @Override
                public K next() {
                    return this.kO().Dh;
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            return LinkedTreeMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object key) {
            return LinkedTreeMap.this.removeInternalByKey(key) != null;
        }

        @Override
        public void clear() {
            LinkedTreeMap.this.clear();
        }
    }

    class a
    extends AbstractSet<Map.Entry<K, V>> {
        a() {
        }

        @Override
        public int size() {
            return LinkedTreeMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new c(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.kO();
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            return o2 instanceof Map.Entry && LinkedTreeMap.this.findByEntry((Map.Entry)o2) != null;
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            d node = LinkedTreeMap.this.findByEntry((Map.Entry)o2);
            if (node == null) {
                return false;
            }
            LinkedTreeMap.this.removeInternal(node, true);
            return true;
        }

        @Override
        public void clear() {
            LinkedTreeMap.this.clear();
        }
    }

    private abstract class c<T>
    implements Iterator<T> {
        d<K, V> CZ;
        d<K, V> Da;
        int Db;

        c() {
            this.CZ = LinkedTreeMap.this.header.CZ;
            this.Da = null;
            this.Db = LinkedTreeMap.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.CZ != LinkedTreeMap.this.header;
        }

        final d<K, V> kO() {
            d e2 = this.CZ;
            if (e2 == LinkedTreeMap.this.header) {
                throw new NoSuchElementException();
            }
            if (LinkedTreeMap.this.modCount != this.Db) {
                throw new ConcurrentModificationException();
            }
            this.CZ = e2.CZ;
            this.Da = e2;
            return this.Da;
        }

        @Override
        public final void remove() {
            if (this.Da == null) {
                throw new IllegalStateException();
            }
            LinkedTreeMap.this.removeInternal(this.Da, true);
            this.Da = null;
            this.Db = LinkedTreeMap.this.modCount;
        }
    }

    static final class d<K, V>
    implements Map.Entry<K, V> {
        d<K, V> Dd;
        d<K, V> De;
        d<K, V> Df;
        d<K, V> CZ;
        d<K, V> Dg;
        final K Dh;
        final boolean Di;
        V value;
        int height;

        d(boolean allowNullValue) {
            this.Dh = null;
            this.Di = allowNullValue;
            this.CZ = this.Dg = this;
        }

        d(boolean allowNullValue, d<K, V> parent, K key, d<K, V> next, d<K, V> prev) {
            this.Dd = parent;
            this.Dh = key;
            this.Di = allowNullValue;
            this.height = 1;
            this.CZ = next;
            this.Dg = prev;
            prev.CZ = this;
            next.Dg = this;
        }

        @Override
        public K getKey() {
            return this.Dh;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null && !this.Di) {
                throw new NullPointerException("value == null");
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o2;
                return (this.Dh == null ? other.getKey() == null : this.Dh.equals(other.getKey())) && (this.value == null ? other.getValue() == null : this.value.equals(other.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.Dh == null ? 0 : this.Dh.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.Dh + "=" + this.value;
        }

        public d<K, V> kP() {
            d<K, V> node = this;
            d<K, V> child = node.De;
            while (child != null) {
                node = child;
                child = node.De;
            }
            return node;
        }

        public d<K, V> kQ() {
            d<K, V> node = this;
            d<K, V> child = node.Df;
            while (child != null) {
                node = child;
                child = node.Df;
            }
            return node;
        }
    }
}

