/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.e;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.a.a;
import com.google.gson.internal.g;
import com.google.gson.internal.j;
import com.google.gson.internal.l;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class b {
    private final Map<Type, e<?>> Cf;
    private final boolean Cg;
    private final List<ReflectionAccessFilter> Ch;

    public b(Map<Type, e<?>> instanceCreators, boolean useJdkUnsafe, List<ReflectionAccessFilter> reflectionFilters) {
        this.Cf = instanceCreators;
        this.Cg = useJdkUnsafe;
        this.Ch = reflectionFilters;
    }

    static String y(Class<?> c2) {
        int modifiers = c2.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            return "Interfaces can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Interface name: " + c2.getName();
        }
        if (Modifier.isAbstract(modifiers)) {
            return "Abstract classes can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Class name: " + c2.getName();
        }
        return null;
    }

    public <T> g<T> b(com.google.gson.b.a<T> typeToken) {
        final Type type = typeToken.lx();
        Class<T> rawType = typeToken.lw();
        final e<?> typeCreator = this.Cf.get(type);
        if (typeCreator != null) {
            return new g<T>(){

                @Override
                public T kH() {
                    return typeCreator.a(type);
                }
            };
        }
        final e<?> rawTypeCreator = this.Cf.get(rawType);
        if (rawTypeCreator != null) {
            return new g<T>(){

                @Override
                public T kH() {
                    return rawTypeCreator.a(type);
                }
            };
        }
        g<T> specialConstructor = b.c(type, rawType);
        if (specialConstructor != null) {
            return specialConstructor;
        }
        ReflectionAccessFilter.FilterResult filterResult = j.b(this.Ch, rawType);
        g<T> defaultConstructor = b.a(rawType, filterResult);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        g<T> defaultImplementation = b.d(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        final String exceptionMessage = b.y(rawType);
        if (exceptionMessage != null) {
            return new g<T>(){

                @Override
                public T kH() {
                    throw new JsonIOException(exceptionMessage);
                }
            };
        }
        if (filterResult == ReflectionAccessFilter.FilterResult.ALLOW) {
            return this.z(rawType);
        }
        final String message = "Unable to create instance of " + rawType + "; ReflectionAccessFilter does not permit using reflection or Unsafe. Register an InstanceCreator or a TypeAdapter for this type or adjust the access filter to allow using reflection.";
        return new g<T>(){

            @Override
            public T kH() {
                throw new JsonIOException(message);
            }
        };
    }

    private static <T> g<T> c(final Type type, Class<? super T> rawType) {
        if (EnumSet.class.isAssignableFrom(rawType)) {
            return new g<T>(){

                @Override
                public T kH() {
                    if (type instanceof ParameterizedType) {
                        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                        if (elementType instanceof Class) {
                            EnumSet set = EnumSet.noneOf((Class)elementType);
                            return set;
                        }
                        throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                    }
                    throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                }
            };
        }
        if (rawType == EnumMap.class) {
            return new g<T>(){

                @Override
                public T kH() {
                    if (type instanceof ParameterizedType) {
                        Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                        if (elementType instanceof Class) {
                            EnumMap map = new EnumMap((Class)elementType);
                            return map;
                        }
                        throw new JsonIOException("Invalid EnumMap type: " + type.toString());
                    }
                    throw new JsonIOException("Invalid EnumMap type: " + type.toString());
                }
            };
        }
        return null;
    }

    private static <T> g<T> a(Class<? super T> rawType, ReflectionAccessFilter.FilterResult filterResult) {
        String exceptionMessage;
        boolean canAccess;
        Constructor<T> constructor;
        if (Modifier.isAbstract(rawType.getModifiers())) {
            return null;
        }
        try {
            constructor = rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
        boolean bl2 = canAccess = filterResult == ReflectionAccessFilter.FilterResult.ALLOW || j.a(constructor, null) && (filterResult != ReflectionAccessFilter.FilterResult.BLOCK_ALL || Modifier.isPublic(constructor.getModifiers()));
        if (!canAccess) {
            final String message = "Unable to invoke no-args constructor of " + rawType + "; constructor is not accessible and ReflectionAccessFilter does not permit making it accessible. Register an InstanceCreator or a TypeAdapter for this type, change the visibility of the constructor or adjust the access filter.";
            return new g<T>(){

                @Override
                public T kH() {
                    throw new JsonIOException(message);
                }
            };
        }
        if (filterResult == ReflectionAccessFilter.FilterResult.ALLOW && (exceptionMessage = a.b(constructor)) != null) {
            return new g<T>(){

                @Override
                public T kH() {
                    throw new JsonIOException(exceptionMessage);
                }
            };
        }
        return new g<T>(){

            @Override
            public T kH() {
                try {
                    Object newInstance = constructor.newInstance(new Object[0]);
                    return newInstance;
                }
                catch (InstantiationException e2) {
                    throw new RuntimeException("Failed to invoke constructor '" + a.a(constructor) + "' with no args", e2);
                }
                catch (InvocationTargetException e3) {
                    throw new RuntimeException("Failed to invoke constructor '" + a.a(constructor) + "' with no args", e3.getCause());
                }
                catch (IllegalAccessException e4) {
                    throw a.a(e4);
                }
            }
        };
    }

    private static <T> g<T> d(Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new TreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new ArrayDeque();
                    }
                };
            }
            return new g<T>(){

                @Override
                public T kH() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new ConcurrentSkipListMap();
                    }
                };
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new ConcurrentHashMap();
                    }
                };
            }
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(com.google.gson.b.a.m(((ParameterizedType)type).getActualTypeArguments()[0]).lw())) {
                return new g<T>(){

                    @Override
                    public T kH() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new g<T>(){

                @Override
                public T kH() {
                    return new LinkedTreeMap();
                }
            };
        }
        return null;
    }

    private <T> g<T> z(final Class<? super T> rawType) {
        if (this.Cg) {
            return new g<T>(){

                @Override
                public T kH() {
                    try {
                        Object newInstance = l.Dp.J(rawType);
                        return newInstance;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("Unable to create instance of " + rawType + ". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.", e2);
                    }
                }
            };
        }
        final String exceptionMessage = "Unable to create instance of " + rawType + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        return new g<T>(){

            @Override
            public T kH() {
                throw new JsonIOException(exceptionMessage);
            }
        };
    }

    public String toString() {
        return this.Cf.toString();
    }
}

