/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.d;
import com.google.gson.internal.h;
import com.google.gson.r;
import com.google.gson.s;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.c;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class DefaultDateTypeAdapter<T extends Date>
extends r<T> {
    private static final String DG = "DefaultDateTypeAdapter";
    private final a<T> DH;
    private final List<DateFormat> DI = new ArrayList<DateFormat>();

    private DefaultDateTypeAdapter(a<T> dateType, String datePattern) {
        this.DH = Objects.requireNonNull(dateType);
        this.DI.add(new SimpleDateFormat(datePattern, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.DI.add(new SimpleDateFormat(datePattern));
        }
    }

    private DefaultDateTypeAdapter(a<T> dateType, int style) {
        this.DH = Objects.requireNonNull(dateType);
        this.DI.add(DateFormat.getDateInstance(style, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.DI.add(DateFormat.getDateInstance(style));
        }
        if (d.kN()) {
            this.DI.add(h.Q(style));
        }
    }

    private DefaultDateTypeAdapter(a<T> dateType, int dateStyle, int timeStyle) {
        this.DH = Objects.requireNonNull(dateType);
        this.DI.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.DI.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle));
        }
        if (d.kN()) {
            this.DI.add(h.f(dateStyle, timeStyle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(c out, Date value) throws IOException {
        String dateFormatAsString;
        if (value == null) {
            out.lq();
            return;
        }
        DateFormat dateFormat = this.DI.get(0);
        List<DateFormat> list = this.DI;
        synchronized (list) {
            dateFormatAsString = dateFormat.format(value);
        }
        out.cQ(dateFormatAsString);
    }

    public T k(com.google.gson.stream.a in) throws IOException {
        if (in.kX() == JsonToken.NULL) {
            in.ld();
            return null;
        }
        Date date = this.l(in);
        return this.DH.c(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date l(com.google.gson.stream.a in) throws IOException {
        String s2 = in.lb();
        List<DateFormat> list = this.DI;
        synchronized (list) {
            for (DateFormat dateFormat : this.DI) {
                try {
                    return dateFormat.parse(s2);
                }
                catch (ParseException parseException) {
                }
            }
        }
        try {
            return com.google.gson.internal.bind.a.a.a(s2, new ParsePosition(0));
        }
        catch (ParseException e2) {
            throw new JsonSyntaxException("Failed parsing '" + s2 + "' as Date; at path " + in.li(), e2);
        }
    }

    public String toString() {
        DateFormat defaultFormat = this.DI.get(0);
        if (defaultFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)defaultFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + defaultFormat.getClass().getSimpleName() + ')';
    }

    @Override
    public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
        return this.k(a2);
    }

    public static abstract class a<T extends Date> {
        public static final a<Date> DJ = new a<Date>(Date.class){

            @Override
            protected Date c(Date date) {
                return date;
            }
        };
        private final Class<T> DK;

        protected a(Class<T> dateClass) {
            this.DK = dateClass;
        }

        protected abstract T c(Date var1);

        private s a(DefaultDateTypeAdapter<T> adapter) {
            return TypeAdapters.a(this.DK, adapter);
        }

        public final s cO(String datePattern) {
            return this.a(new DefaultDateTypeAdapter(this, datePattern));
        }

        public final s V(int style) {
            return this.a(new DefaultDateTypeAdapter(this, style));
        }

        public final s i(int dateStyle, int timeStyle) {
            return this.a(new DefaultDateTypeAdapter(this, dateStyle, timeStyle));
        }

        public final s kS() {
            return this.a(new DefaultDateTypeAdapter(this, 2, 2));
        }
    }
}

