/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.a.c;
import com.google.gson.f;
import com.google.gson.i;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.a;
import com.google.gson.j;
import com.google.gson.k;
import com.google.gson.m;
import com.google.gson.r;
import com.google.gson.s;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final r<Class> Fg = new r<Class>(){

        @Override
        public void a(com.google.gson.stream.c out, Class value) throws IOException {
            throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + value.getName() + ". Forgot to register a type adapter?");
        }

        public Class n(com.google.gson.stream.a in) throws IOException {
            throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.n(a2);
        }
    }.kB();
    public static final s Fh = TypeAdapters.a(Class.class, Fg);
    public static final r<BitSet> Fi = new r<BitSet>(){

        public BitSet v(com.google.gson.stream.a in) throws IOException {
            BitSet bitset = new BitSet();
            in.kT();
            int i2 = 0;
            JsonToken tokenType = in.kX();
            while (tokenType != JsonToken.END_ARRAY) {
                boolean set;
                switch (tokenType) {
                    case NUMBER: 
                    case STRING: {
                        int intValue = in.nextInt();
                        if (intValue == 0) {
                            set = false;
                            break;
                        }
                        if (intValue == 1) {
                            set = true;
                            break;
                        }
                        throw new JsonSyntaxException("Invalid bitset value " + intValue + ", expected 0 or 1; at path " + in.li());
                    }
                    case BOOLEAN: {
                        set = in.lc();
                        break;
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)tokenType) + "; at path " + in.gR());
                    }
                }
                if (set) {
                    bitset.set(i2);
                }
                ++i2;
                tokenType = in.kX();
            }
            in.kU();
            return bitset;
        }

        @Override
        public void a(com.google.gson.stream.c out, BitSet src) throws IOException {
            out.lm();
            int length = src.length();
            for (int i2 = 0; i2 < length; ++i2) {
                int value = src.get(i2) ? 1 : 0;
                out.H(value);
            }
            out.ln();
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.v(a2);
        }
    }.kB();
    public static final s Fj = TypeAdapters.a(BitSet.class, Fi);
    public static final r<Boolean> Fk = new r<Boolean>(){

        public Boolean F(com.google.gson.stream.a in) throws IOException {
            JsonToken peek = in.kX();
            if (peek == JsonToken.NULL) {
                in.ld();
                return null;
            }
            if (peek == JsonToken.STRING) {
                return Boolean.parseBoolean(in.lb());
            }
            return in.lc();
        }

        @Override
        public void a(com.google.gson.stream.c out, Boolean value) throws IOException {
            out.d(value);
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.F(a2);
        }
    };
    public static final r<Boolean> Fl = new r<Boolean>(){

        public Boolean F(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return Boolean.valueOf(in.lb());
        }

        @Override
        public void a(com.google.gson.stream.c out, Boolean value) throws IOException {
            out.cQ(value == null ? "null" : value.toString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.F(a2);
        }
    };
    public static final s Fm = TypeAdapters.a(Boolean.TYPE, Boolean.class, Fk);
    public static final r<Number> Fn = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            int intValue;
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            try {
                intValue = in.nextInt();
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException(e2);
            }
            if (intValue > 255 || intValue < -128) {
                throw new JsonSyntaxException("Lossy conversion from " + intValue + " to byte; at path " + in.li());
            }
            return (byte)intValue;
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                out.H(value.byteValue());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final s Fo = TypeAdapters.a(Byte.TYPE, Byte.class, Fn);
    public static final r<Number> Fp = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            int intValue;
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            try {
                intValue = in.nextInt();
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException(e2);
            }
            if (intValue > 65535 || intValue < Short.MIN_VALUE) {
                throw new JsonSyntaxException("Lossy conversion from " + intValue + " to short; at path " + in.li());
            }
            return (short)intValue;
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                out.H(value.shortValue());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final s Fq = TypeAdapters.a(Short.TYPE, Short.class, Fp);
    public static final r<Number> Fr = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            try {
                return in.nextInt();
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException(e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                out.H(value.intValue());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final s Fs = TypeAdapters.a(Integer.TYPE, Integer.class, Fr);
    public static final r<AtomicInteger> Ft = new r<AtomicInteger>(){

        public AtomicInteger G(com.google.gson.stream.a in) throws IOException {
            try {
                return new AtomicInteger(in.nextInt());
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException(e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, AtomicInteger value) throws IOException {
            out.H(value.get());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.G(a2);
        }
    }.kB();
    public static final s Fu = TypeAdapters.a(AtomicInteger.class, Ft);
    public static final r<AtomicBoolean> Fv = new r<AtomicBoolean>(){

        public AtomicBoolean H(com.google.gson.stream.a in) throws IOException {
            return new AtomicBoolean(in.lc());
        }

        @Override
        public void a(com.google.gson.stream.c out, AtomicBoolean value) throws IOException {
            out.K(value.get());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.H(a2);
        }
    }.kB();
    public static final s Fw = TypeAdapters.a(AtomicBoolean.class, Fv);
    public static final r<AtomicIntegerArray> Fx = new r<AtomicIntegerArray>(){

        public AtomicIntegerArray o(com.google.gson.stream.a in) throws IOException {
            ArrayList<Integer> list = new ArrayList<Integer>();
            in.kT();
            while (in.hasNext()) {
                try {
                    int integer = in.nextInt();
                    list.add(integer);
                }
                catch (NumberFormatException e2) {
                    throw new JsonSyntaxException(e2);
                }
            }
            in.kU();
            int length = list.size();
            AtomicIntegerArray array = new AtomicIntegerArray(length);
            for (int i2 = 0; i2 < length; ++i2) {
                array.set(i2, (Integer)list.get(i2));
            }
            return array;
        }

        @Override
        public void a(com.google.gson.stream.c out, AtomicIntegerArray value) throws IOException {
            out.lm();
            int length = value.length();
            for (int i2 = 0; i2 < length; ++i2) {
                out.H(value.get(i2));
            }
            out.ln();
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.o(a2);
        }
    }.kB();
    public static final s Fy = TypeAdapters.a(AtomicIntegerArray.class, Fx);
    public static final r<Number> Fz = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            try {
                return in.nextLong();
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException(e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                out.H(value.longValue());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final r<Number> FA = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return Float.valueOf((float)in.le());
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                Number floatNumber = value instanceof Float ? (Number)value : (Number)Float.valueOf(value.floatValue());
                out.b(floatNumber);
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final r<Number> FB = new r<Number>(){

        public Number d(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return in.le();
        }

        @Override
        public void a(com.google.gson.stream.c out, Number value) throws IOException {
            if (value == null) {
                out.lq();
            } else {
                out.k(value.doubleValue());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.d(a2);
        }
    };
    public static final r<Character> FC = new r<Character>(){

        public Character p(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String str = in.lb();
            if (str.length() != 1) {
                throw new JsonSyntaxException("Expecting character, got: " + str + "; at " + in.li());
            }
            return Character.valueOf(str.charAt(0));
        }

        @Override
        public void a(com.google.gson.stream.c out, Character value) throws IOException {
            out.cQ(value == null ? null : String.valueOf(value));
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.p(a2);
        }
    };
    public static final s FD = TypeAdapters.a(Character.TYPE, Character.class, FC);
    public static final r<String> FE = new r<String>(){

        public String q(com.google.gson.stream.a in) throws IOException {
            JsonToken peek = in.kX();
            if (peek == JsonToken.NULL) {
                in.ld();
                return null;
            }
            if (peek == JsonToken.BOOLEAN) {
                return Boolean.toString(in.lc());
            }
            return in.lb();
        }

        @Override
        public void a(com.google.gson.stream.c out, String value) throws IOException {
            out.cQ(value);
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.q(a2);
        }
    };
    public static final r<BigDecimal> FF = new r<BigDecimal>(){

        public BigDecimal r(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String s2 = in.lb();
            try {
                return new BigDecimal(s2);
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException("Failed parsing '" + s2 + "' as BigDecimal; at path " + in.li(), e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, BigDecimal value) throws IOException {
            out.b(value);
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.r(a2);
        }
    };
    public static final r<BigInteger> FG = new r<BigInteger>(){

        public BigInteger s(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String s2 = in.lb();
            try {
                return new BigInteger(s2);
            }
            catch (NumberFormatException e2) {
                throw new JsonSyntaxException("Failed parsing '" + s2 + "' as BigInteger; at path " + in.li(), e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, BigInteger value) throws IOException {
            out.b(value);
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.s(a2);
        }
    };
    public static final r<LazilyParsedNumber> FH = new r<LazilyParsedNumber>(){

        public LazilyParsedNumber t(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return new LazilyParsedNumber(in.lb());
        }

        @Override
        public void a(com.google.gson.stream.c out, LazilyParsedNumber value) throws IOException {
            out.b(value);
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.t(a2);
        }
    };
    public static final s FI = TypeAdapters.a(String.class, FE);
    public static final r<StringBuilder> FJ = new r<StringBuilder>(){

        public StringBuilder u(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return new StringBuilder(in.lb());
        }

        @Override
        public void a(com.google.gson.stream.c out, StringBuilder value) throws IOException {
            out.cQ(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.u(a2);
        }
    };
    public static final s FL = TypeAdapters.a(StringBuilder.class, FJ);
    public static final r<StringBuffer> FM = new r<StringBuffer>(){

        public StringBuffer w(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return new StringBuffer(in.lb());
        }

        @Override
        public void a(com.google.gson.stream.c out, StringBuffer value) throws IOException {
            out.cQ(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.w(a2);
        }
    };
    public static final s FN = TypeAdapters.a(StringBuffer.class, FM);
    public static final r<URL> FO = new r<URL>(){

        public URL x(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String nextString = in.lb();
            return "null".equals(nextString) ? null : new URL(nextString);
        }

        @Override
        public void a(com.google.gson.stream.c out, URL value) throws IOException {
            out.cQ(value == null ? null : value.toExternalForm());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.x(a2);
        }
    };
    public static final s FP = TypeAdapters.a(URL.class, FO);
    public static final r<URI> FQ = new r<URI>(){

        public URI y(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            try {
                String nextString = in.lb();
                return "null".equals(nextString) ? null : new URI(nextString);
            }
            catch (URISyntaxException e2) {
                throw new JsonIOException(e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, URI value) throws IOException {
            out.cQ(value == null ? null : value.toASCIIString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.y(a2);
        }
    };
    public static final s FS = TypeAdapters.a(URI.class, FQ);
    public static final r<InetAddress> FT = new r<InetAddress>(){

        public InetAddress z(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            return InetAddress.getByName(in.lb());
        }

        @Override
        public void a(com.google.gson.stream.c out, InetAddress value) throws IOException {
            out.cQ(value == null ? null : value.getHostAddress());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.z(a2);
        }
    };
    public static final s FU = TypeAdapters.b(InetAddress.class, FT);
    public static final r<UUID> FV = new r<UUID>(){

        public UUID A(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String s2 = in.lb();
            try {
                return UUID.fromString(s2);
            }
            catch (IllegalArgumentException e2) {
                throw new JsonSyntaxException("Failed parsing '" + s2 + "' as UUID; at path " + in.li(), e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, UUID value) throws IOException {
            out.cQ(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.A(a2);
        }
    };
    public static final s FW = TypeAdapters.a(UUID.class, FV);
    public static final r<Currency> FX = new r<Currency>(){

        public Currency B(com.google.gson.stream.a in) throws IOException {
            String s2 = in.lb();
            try {
                return Currency.getInstance(s2);
            }
            catch (IllegalArgumentException e2) {
                throw new JsonSyntaxException("Failed parsing '" + s2 + "' as Currency; at path " + in.li(), e2);
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, Currency value) throws IOException {
            out.cQ(value.getCurrencyCode());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.B(a2);
        }
    }.kB();
    public static final s FY = TypeAdapters.a(Currency.class, FX);
    public static final r<Calendar> FZ = new r<Calendar>(){
        private static final String Gg = "year";
        private static final String Gh = "month";
        private static final String Gi = "dayOfMonth";
        private static final String Gj = "hourOfDay";
        private static final String Gk = "minute";
        private static final String Gl = "second";

        public Calendar C(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            in.kV();
            int year = 0;
            int month = 0;
            int dayOfMonth = 0;
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            while (in.kX() != JsonToken.END_OBJECT) {
                String name = in.la();
                int value = in.nextInt();
                if (Gg.equals(name)) {
                    year = value;
                    continue;
                }
                if (Gh.equals(name)) {
                    month = value;
                    continue;
                }
                if (Gi.equals(name)) {
                    dayOfMonth = value;
                    continue;
                }
                if (Gj.equals(name)) {
                    hourOfDay = value;
                    continue;
                }
                if (Gk.equals(name)) {
                    minute = value;
                    continue;
                }
                if (!Gl.equals(name)) continue;
                second = value;
            }
            in.kW();
            return new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        }

        @Override
        public void a(com.google.gson.stream.c out, Calendar value) throws IOException {
            if (value == null) {
                out.lq();
                return;
            }
            out.lo();
            out.cP(Gg);
            out.H(value.get(1));
            out.cP(Gh);
            out.H(value.get(2));
            out.cP(Gi);
            out.H(value.get(5));
            out.cP(Gj);
            out.H(value.get(11));
            out.cP(Gk);
            out.H(value.get(12));
            out.cP(Gl);
            out.H(value.get(13));
            out.lp();
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.C(a2);
        }
    };
    public static final s Ga = TypeAdapters.b(Calendar.class, GregorianCalendar.class, FZ);
    public static final r<Locale> Gb = new r<Locale>(){

        public Locale D(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String locale = in.lb();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        @Override
        public void a(com.google.gson.stream.c out, Locale value) throws IOException {
            out.cQ(value == null ? null : value.toString());
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.D(a2);
        }
    };
    public static final s Gc = TypeAdapters.a(Locale.class, Gb);
    public static final r<i> Gd = new r<i>(){

        private i c(com.google.gson.stream.a in, JsonToken peeked) throws IOException {
            switch (peeked) {
                case BEGIN_ARRAY: {
                    in.kT();
                    return new f();
                }
                case BEGIN_OBJECT: {
                    in.kV();
                    return new k();
                }
            }
            return null;
        }

        private i d(com.google.gson.stream.a in, JsonToken peeked) throws IOException {
            switch (peeked) {
                case STRING: {
                    return new m(in.lb());
                }
                case NUMBER: {
                    String number = in.lb();
                    return new m(new LazilyParsedNumber(number));
                }
                case BOOLEAN: {
                    return new m(in.lc());
                }
                case NULL: {
                    in.ld();
                    return j.BR;
                }
            }
            throw new IllegalStateException("Unexpected token: " + (Object)((Object)peeked));
        }

        public i E(com.google.gson.stream.a in) throws IOException {
            if (in instanceof a) {
                return ((a)in).lf();
            }
            JsonToken peeked = in.kX();
            i current = this.c(in, peeked);
            if (current == null) {
                return this.d(in, peeked);
            }
            ArrayDeque<i> stack = new ArrayDeque<i>();
            while (true) {
                if (in.hasNext()) {
                    i value;
                    boolean isNesting;
                    String name = null;
                    if (current instanceof k) {
                        name = in.la();
                    }
                    boolean bl2 = isNesting = (value = this.c(in, peeked = in.kX())) != null;
                    if (value == null) {
                        value = this.d(in, peeked);
                    }
                    if (current instanceof f) {
                        ((f)current).b(value);
                    } else {
                        ((k)current).a(name, value);
                    }
                    if (!isNesting) continue;
                    stack.addLast(current);
                    current = value;
                    continue;
                }
                if (current instanceof f) {
                    in.kU();
                } else {
                    in.kW();
                }
                if (stack.isEmpty()) {
                    return current;
                }
                current = (i)stack.removeLast();
            }
        }

        @Override
        public void a(com.google.gson.stream.c out, i value) throws IOException {
            if (value == null || value.ko()) {
                out.lq();
            } else if (value.kn()) {
                m primitive = value.kr();
                if (primitive.ky()) {
                    out.b(primitive.jZ());
                } else if (primitive.kx()) {
                    out.K(primitive.getAsBoolean());
                } else {
                    out.cQ(primitive.ka());
                }
            } else if (value.kl()) {
                out.lm();
                for (i e2 : value.kq()) {
                    this.a(out, e2);
                }
                out.ln();
            } else if (value.km()) {
                out.lo();
                for (Map.Entry<String, i> e3 : value.kp().entrySet()) {
                    out.cP(e3.getKey());
                    this.a(out, e3.getValue());
                }
                out.lp();
            } else {
                throw new IllegalArgumentException("Couldn't write " + value.getClass());
            }
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.E(a2);
        }
    };
    public static final s Ge = TypeAdapters.b(i.class, Gd);
    public static final s Gf = new s(){

        @Override
        public <T> r<T> a(Gson gson, com.google.gson.b.a<T> typeToken) {
            Class<T> rawType = typeToken.lw();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            EnumTypeAdapter<T> adapter = new EnumTypeAdapter<T>(rawType);
            return adapter;
        }
    };

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <TT> s a(final com.google.gson.b.a<TT> type, final r<TT> typeAdapter) {
        return new s(){

            @Override
            public <T> r<T> a(Gson gson, com.google.gson.b.a<T> typeToken) {
                return typeToken.equals(type) ? typeAdapter : null;
            }
        };
    }

    public static <TT> s a(final Class<TT> type, final r<TT> typeAdapter) {
        return new s(){

            @Override
            public <T> r<T> a(Gson gson, com.google.gson.b.a<T> typeToken) {
                return typeToken.lw() == type ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + type.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> s a(final Class<TT> unboxed, final Class<TT> boxed, final r<? super TT> typeAdapter) {
        return new s(){

            @Override
            public <T> r<T> a(Gson gson, com.google.gson.b.a<T> typeToken) {
                Class<T> rawType = typeToken.lw();
                return rawType == unboxed || rawType == boxed ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + boxed.getName() + "+" + unboxed.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <TT> s b(final Class<TT> base, final Class<? extends TT> sub, final r<? super TT> typeAdapter) {
        return new s(){

            @Override
            public <T> r<T> a(Gson gson, com.google.gson.b.a<T> typeToken) {
                Class<T> rawType = typeToken.lw();
                return rawType == base || rawType == sub ? typeAdapter : null;
            }

            public String toString() {
                return "Factory[type=" + base.getName() + "+" + sub.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    public static <T1> s b(final Class<T1> clazz, final r<T1> typeAdapter) {
        return new s(){

            public <T2> r<T2> a(Gson gson, com.google.gson.b.a<T2> typeToken) {
                final Class<T2> requestedType = typeToken.lw();
                if (!clazz.isAssignableFrom(requestedType)) {
                    return null;
                }
                return new r<T1>(){

                    @Override
                    public void a(com.google.gson.stream.c out, T1 value) throws IOException {
                        typeAdapter.a(out, value);
                    }

                    @Override
                    public T1 b(com.google.gson.stream.a in) throws IOException {
                        Object result = typeAdapter.b(in);
                        if (result != null && !requestedType.isInstance(result)) {
                            throw new JsonSyntaxException("Expected a " + requestedType.getName() + " but was " + result.getClass().getName() + "; at path " + in.li());
                        }
                        return result;
                    }
                };
            }

            public String toString() {
                return "Factory[typeHierarchy=" + clazz.getName() + ",adapter=" + typeAdapter + "]";
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends r<T> {
        private final Map<String, T> GB = new HashMap<String, T>();
        private final Map<String, T> GC = new HashMap<String, T>();
        private final Map<T, String> GD = new HashMap<T, String>();

        public EnumTypeAdapter(final Class<T> classOfT) {
            try {
                Field[] constantFields;
                for (Field constantField : constantFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                    public Field[] lu() {
                        Field[] fields = classOfT.getDeclaredFields();
                        ArrayList<Field> constantFieldsList = new ArrayList<Field>(fields.length);
                        for (Field f2 : fields) {
                            if (!f2.isEnumConstant()) continue;
                            constantFieldsList.add(f2);
                        }
                        AccessibleObject[] constantFields = constantFieldsList.toArray(new Field[0]);
                        AccessibleObject.setAccessible(constantFields, true);
                        return constantFields;
                    }

                    @Override
                    public /* synthetic */ Object run() {
                        return this.lu();
                    }
                })) {
                    Enum constant = (Enum)constantField.get(null);
                    String name = constant.name();
                    String toStringVal = constant.toString();
                    c annotation = constantField.getAnnotation(c.class);
                    if (annotation != null) {
                        name = annotation.value();
                        for (String alternate : annotation.kF()) {
                            this.GB.put(alternate, constant);
                        }
                    }
                    this.GB.put(name, constant);
                    this.GC.put(toStringVal, constant);
                    this.GD.put(constant, name);
                }
            }
            catch (IllegalAccessException e2) {
                throw new AssertionError((Object)e2);
            }
        }

        public T I(com.google.gson.stream.a in) throws IOException {
            if (in.kX() == JsonToken.NULL) {
                in.ld();
                return null;
            }
            String key = in.lb();
            Enum constant = (Enum)this.GB.get(key);
            return (T)(constant == null ? (Enum)this.GC.get(key) : constant);
        }

        @Override
        public void a(com.google.gson.stream.c out, T value) throws IOException {
            out.cQ(value == null ? null : this.GD.get(value));
        }

        @Override
        public /* synthetic */ Object b(com.google.gson.stream.a a2) throws IOException {
            return this.I(a2);
        }
    }
}

