/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind.a;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class a {
    private static final String GG = "UTC";
    private static final TimeZone GH = TimeZone.getTimeZone("UTC");

    public static String d(Date date) {
        return a.a(date, false, GH);
    }

    public static String a(Date date, boolean millis) {
        return a.a(date, millis, GH);
    }

    public static String a(Date date, boolean millis, TimeZone tz) {
        int offset;
        GregorianCalendar calendar = new GregorianCalendar(tz, Locale.US);
        calendar.setTime(date);
        int capacity = "yyyy-MM-ddThh:mm:ss".length();
        capacity += millis ? ".sss".length() : 0;
        StringBuilder formatted = new StringBuilder(capacity += tz.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        a.a(formatted, calendar.get(1), "yyyy".length());
        formatted.append('-');
        a.a(formatted, calendar.get(2) + 1, "MM".length());
        formatted.append('-');
        a.a(formatted, calendar.get(5), "dd".length());
        formatted.append('T');
        a.a(formatted, calendar.get(11), "hh".length());
        formatted.append(':');
        a.a(formatted, calendar.get(12), "mm".length());
        formatted.append(':');
        a.a(formatted, calendar.get(13), "ss".length());
        if (millis) {
            formatted.append('.');
            a.a(formatted, calendar.get(14), "sss".length());
        }
        if ((offset = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            formatted.append(offset < 0 ? (char)'-' : '+');
            a.a(formatted, hours, "hh".length());
            formatted.append(':');
            a.a(formatted, minutes, "mm".length());
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    public static Date a(String date, ParsePosition pos) throws ParseException {
        RuntimeException fail = null;
        try {
            int offset = pos.getIndex();
            int year = a.a(date, offset, offset += 4);
            if (a.a(date, offset, '-')) {
                // empty if block
            }
            int month = a.a(date, ++offset, offset += 2);
            if (a.a(date, offset, '-')) {
                // empty if block
            }
            int day = a.a(date, ++offset, offset += 2);
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int milliseconds = 0;
            boolean hasT = a.a(date, offset, 'T');
            if (!hasT && date.length() <= offset) {
                GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
                calendar.setLenient(false);
                pos.setIndex(offset);
                return calendar.getTime();
            }
            if (hasT) {
                char c2;
                hour = a.a(date, ++offset, offset += 2);
                if (a.a(date, offset, ':')) {
                    // empty if block
                }
                minutes = a.a(date, ++offset, offset += 2);
                if (a.a(date, offset, ':')) {
                    ++offset;
                }
                if (date.length() > offset && (c2 = date.charAt(offset)) != 'Z' && c2 != '+' && c2 != '-') {
                    if ((seconds = a.a(date, offset, offset += 2)) > 59 && seconds < 63) {
                        seconds = 59;
                    }
                    if (a.a(date, offset, '.')) {
                        int endOffset = a.b(date, ++offset + 1);
                        int parseEndOffset = Math.min(endOffset, offset + 3);
                        int fraction = a.a(date, offset, parseEndOffset);
                        switch (parseEndOffset - offset) {
                            case 2: {
                                milliseconds = fraction * 10;
                                break;
                            }
                            case 1: {
                                milliseconds = fraction * 100;
                                break;
                            }
                            default: {
                                milliseconds = fraction;
                            }
                        }
                        offset = endOffset;
                    }
                }
            }
            if (date.length() <= offset) {
                throw new IllegalArgumentException("No time zone indicator");
            }
            TimeZone timezone = null;
            char timezoneIndicator = date.charAt(offset);
            if (timezoneIndicator == 'Z') {
                timezone = GH;
                ++offset;
            } else if (timezoneIndicator == '+' || timezoneIndicator == '-') {
                String timezoneOffset = date.substring(offset);
                timezoneOffset = timezoneOffset.length() >= 5 ? timezoneOffset : timezoneOffset + "00";
                offset += timezoneOffset.length();
                if ("+0000".equals(timezoneOffset) || "+00:00".equals(timezoneOffset)) {
                    timezone = GH;
                } else {
                    String cleaned;
                    String timezoneId = "GMT" + timezoneOffset;
                    timezone = TimeZone.getTimeZone(timezoneId);
                    String act = timezone.getID();
                    if (!act.equals(timezoneId) && !(cleaned = act.replace(":", "")).equals(timezoneId)) {
                        throw new IndexOutOfBoundsException("Mismatching time zone indicator: " + timezoneId + " given, resolves to " + timezone.getID());
                    }
                }
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator '" + timezoneIndicator + "'");
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos.setIndex(offset);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException e2) {
            fail = e2;
        }
        catch (NumberFormatException e3) {
            fail = e3;
        }
        catch (IllegalArgumentException e4) {
            fail = e4;
        }
        String input = date == null ? null : '\"' + date + '\"';
        String msg = fail.getMessage();
        if (msg == null || msg.isEmpty()) {
            msg = "(" + fail.getClass().getName() + ")";
        }
        ParseException ex = new ParseException("Failed to parse date [" + input + "]: " + msg, pos.getIndex());
        ex.initCause(fail);
        throw ex;
    }

    private static boolean a(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int a(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i2 = beginIndex;
        int result = 0;
        if (i2 < endIndex) {
            if ((digit = Character.digit(value.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result = -digit;
        }
        while (i2 < endIndex) {
            if ((digit = Character.digit(value.charAt(i2++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + value.substring(beginIndex, endIndex));
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    private static void a(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i2 = length - strValue.length(); i2 > 0; --i2) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    private static int b(String string, int offset) {
        for (int i2 = offset; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return i2;
        }
        return string.length();
    }
}

