/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class c
implements Closeable,
Flushable {
    private static final Pattern HV = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] HW = new String[128];
    private static final String[] HX;
    private final Writer HY;
    private int[] HL = new int[32];
    private int DQ = 0;
    private String HZ;
    private String Ia;
    private boolean Br;
    private boolean Bp;
    private String Ib;
    private boolean Bm;

    public c(Writer out) {
        this.push(6);
        this.Ia = ":";
        this.Bm = true;
        this.HY = Objects.requireNonNull(out, "out == null");
    }

    public final void cU(String indent) {
        if (indent.length() == 0) {
            this.HZ = null;
            this.Ia = ":";
        } else {
            this.HZ = indent;
            this.Ia = ": ";
        }
    }

    public final void N(boolean lenient) {
        this.Br = lenient;
    }

    public boolean ly() {
        return this.Br;
    }

    public final void O(boolean htmlSafe) {
        this.Bp = htmlSafe;
    }

    public final boolean lI() {
        return this.Bp;
    }

    public final void P(boolean serializeNulls) {
        this.Bm = serializeNulls;
    }

    public final boolean lJ() {
        return this.Bm;
    }

    public c lm() throws IOException {
        this.lL();
        return this.a(1, '[');
    }

    public c ln() throws IOException {
        return this.a(1, 2, ']');
    }

    public c lo() throws IOException {
        this.lL();
        return this.a(3, '{');
    }

    public c lp() throws IOException {
        return this.a(3, 5, '}');
    }

    private c a(int empty, char openBracket) throws IOException {
        this.lO();
        this.push(empty);
        this.HY.write(openBracket);
        return this;
    }

    private c a(int empty, int nonempty, char closeBracket) throws IOException {
        int context = this.lK();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.Ib != null) {
            throw new IllegalStateException("Dangling name: " + this.Ib);
        }
        --this.DQ;
        if (context == nonempty) {
            this.lM();
        }
        this.HY.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.DQ == this.HL.length) {
            this.HL = Arrays.copyOf(this.HL, this.DQ * 2);
        }
        this.HL[this.DQ++] = newTop;
    }

    private int lK() {
        if (this.DQ == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.HL[this.DQ - 1];
    }

    private void X(int topOfStack) {
        this.HL[this.DQ - 1] = topOfStack;
    }

    public c cP(String name) throws IOException {
        Objects.requireNonNull(name, "name == null");
        if (this.Ib != null) {
            throw new IllegalStateException();
        }
        if (this.DQ == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.Ib = name;
        return this;
    }

    private void lL() throws IOException {
        if (this.Ib != null) {
            this.lN();
            this.cV(this.Ib);
            this.Ib = null;
        }
    }

    public c cQ(String value) throws IOException {
        if (value == null) {
            return this.lq();
        }
        this.lL();
        this.lO();
        this.cV(value);
        return this;
    }

    public c cR(String value) throws IOException {
        if (value == null) {
            return this.lq();
        }
        this.lL();
        this.lO();
        this.HY.append(value);
        return this;
    }

    public c lq() throws IOException {
        if (this.Ib != null) {
            if (this.Bm) {
                this.lL();
            } else {
                this.Ib = null;
                return this;
            }
        }
        this.lO();
        this.HY.write("null");
        return this;
    }

    public c K(boolean value) throws IOException {
        this.lL();
        this.lO();
        this.HY.write(value ? "true" : "false");
        return this;
    }

    public c d(Boolean value) throws IOException {
        if (value == null) {
            return this.lq();
        }
        this.lL();
        this.lO();
        this.HY.write(value != false ? "true" : "false");
        return this;
    }

    public c a(float value) throws IOException {
        this.lL();
        if (!this.Br && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.lO();
        this.HY.append(Float.toString(value));
        return this;
    }

    public c k(double value) throws IOException {
        this.lL();
        if (!this.Br && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.lO();
        this.HY.append(Double.toString(value));
        return this;
    }

    public c H(long value) throws IOException {
        this.lL();
        this.lO();
        this.HY.write(Long.toString(value));
        return this;
    }

    private static boolean R(Class<? extends Number> c2) {
        return c2 == Integer.class || c2 == Long.class || c2 == Double.class || c2 == Float.class || c2 == Byte.class || c2 == Short.class || c2 == BigDecimal.class || c2 == BigInteger.class || c2 == AtomicInteger.class || c2 == AtomicLong.class;
    }

    public c b(Number value) throws IOException {
        if (value == null) {
            return this.lq();
        }
        this.lL();
        String string = value.toString();
        if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
            if (!this.Br) {
                throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
            }
        } else {
            Class<?> numberClass = value.getClass();
            if (!c.R(numberClass) && !HV.matcher(string).matches()) {
                throw new IllegalArgumentException("String created by " + numberClass + " is not a valid JSON number: " + string);
            }
        }
        this.lO();
        this.HY.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.DQ == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.HY.flush();
    }

    @Override
    public void close() throws IOException {
        this.HY.close();
        int size = this.DQ;
        if (size > 1 || size == 1 && this.HL[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.DQ = 0;
    }

    private void cV(String value) throws IOException {
        String[] replacements = this.Bp ? HX : HW;
        this.HY.write(34);
        int last = 0;
        int length = value.length();
        for (int i2 = 0; i2 < length; ++i2) {
            String replacement;
            char c2 = value.charAt(i2);
            if (c2 < '\u0080') {
                replacement = replacements[c2];
                if (replacement == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i2) {
                this.HY.write(value, last, i2 - last);
            }
            this.HY.write(replacement);
            last = i2 + 1;
        }
        if (last < length) {
            this.HY.write(value, last, length - last);
        }
        this.HY.write(34);
    }

    private void lM() throws IOException {
        if (this.HZ == null) {
            return;
        }
        this.HY.write(10);
        int size = this.DQ;
        for (int i2 = 1; i2 < size; ++i2) {
            this.HY.write(this.HZ);
        }
    }

    private void lN() throws IOException {
        int context = this.lK();
        if (context == 5) {
            this.HY.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.lM();
        this.X(4);
    }

    private void lO() throws IOException {
        switch (this.lK()) {
            case 7: {
                if (!this.Br) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.X(7);
                break;
            }
            case 1: {
                this.X(2);
                this.lM();
                break;
            }
            case 2: {
                this.HY.append(',');
                this.lM();
                break;
            }
            case 4: {
                this.HY.append(this.Ia);
                this.X(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            c.HW[i2] = String.format("\\u%04x", i2);
        }
        c.HW[34] = "\\\"";
        c.HW[92] = "\\\\";
        c.HW[9] = "\\t";
        c.HW[8] = "\\b";
        c.HW[10] = "\\n";
        c.HW[13] = "\\r";
        c.HW[12] = "\\f";
        HX = (String[])HW.clone();
        c.HX[60] = "\\u003c";
        c.HX[62] = "\\u003e";
        c.HX[38] = "\\u0026";
        c.HX[61] = "\\u003d";
        c.HX[39] = "\\u0027";
    }
}

