/*
 * Decompiled with CFR 0.152.
 */
package com.sec.xincipher.simkey.kms.asn1;

import com.sec.xincipher.simkey.kms.asn1.gmt0009.Header04;
import com.sec.xincipher.simkey.sdf.ECCrefPublicKey;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import tech.simkey.dove.num.ByteUtil;

public class EnvelopedSM2Key
implements ASN1Encodable {
    int version;
    private final byte[] publicKeyWith04;
    private final byte[] encryptedPrivKey;

    public static EnvelopedSM2Key getInstance(Object obj) {
        if (obj instanceof EnvelopedSM2Key) {
            return (EnvelopedSM2Key)obj;
        }
        if (obj != null) {
            Object object;
            return new EnvelopedSM2Key(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public EnvelopedSM2Key(byte[] publicKey, boolean with04, byte[] encryptedPrivKey) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.version = 1;
        this.publicKeyWith04 = var2_2 != false ? publicKey : ByteUtil.contact(Header04.header, (byte[])var1_1);
        this.encryptedPrivKey = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public EnvelopedSM2Key(ECCrefPublicKey publicKey, byte[] encryptedPrivKey) {
        void var2_2;
        byte[] byArray;
        this.version = 1;
        byte[] byArray2 = ByteUtil.subBytes(publicKey.x, 32, 32);
        byArray = ByteUtil.subBytes(byArray.y, 32, 32);
        this.publicKeyWith04 = ByteUtil.contact2(Header04.header, byArray2, byArray);
        this.encryptedPrivKey = var2_2;
    }

    private EnvelopedSM2Key(ASN1Sequence seq) {
        Enumeration enumeration;
        if (seq.size() < 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        enumeration = ((ASN1Sequence)((Object)enumeration)).getObjects();
        this.version = ASN1Integer.getInstance(enumeration.nextElement()).getValue().intValue();
        this.publicKeyWith04 = DERBitString.getInstance(enumeration.nextElement()).getOctets();
        this.encryptedPrivKey = DERBitString.getInstance(enumeration.nextElement()).getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.version));
        aSN1EncodableVector.add(new DERBitString(this.publicKeyWith04));
        aSN1EncodableVector.add(new DERBitString(this.encryptedPrivKey));
        return new DERSequence(aSN1EncodableVector);
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getPublicKeyNo04() {
        return ByteUtil.subBytes(this.publicKeyWith04, 1, this.publicKeyWith04.length - 1);
    }

    public byte[] getPublicWith04() {
        return this.publicKeyWith04;
    }

    public byte[] getEncryptedPrivKey() {
        return this.encryptedPrivKey;
    }
}

